package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2016/12/28
 * @description 中国移动短信服务--仪征
 */
public class CmccSmsServiceForYizImpl implements SmsService {

    private static final String PHONE_NUMBER_NULL="电话号码为空！";

    private static final String CONTENT_NUMBER_NULL="短信内容为空！";

    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if (StringUtils.isBlank(phoneNum))
            throw new AppException(PHONE_NUMBER_NULL);
        if (StringUtils.isBlank(content))
            throw new AppException(CONTENT_NUMBER_NULL);
        String sql = "INSERT INTO cs (MOBILEPHONE, CONTENT,RETURNFLAG, AB) VALUES (?,?,?,?)";
        try {
            Object[] param = new Object[4];
            param[0] = phoneNum;
            param[1] = content;
            param[2] = Integer.toString(0);
            param[3] = StringUtils.EMPTY;
            jdbcTemplate.update(sql, param);
        } catch (Exception var5) {
            throw new AppException(var5.getMessage());
        }
        return null;
    }
}
