/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.mybatis.page;

import cn.gtmap.estateplat.core.support.mybatis.page.dialect.DatabaseDialectShortName;
import cn.gtmap.estateplat.core.support.mybatis.page.dialect.Dialect;
import cn.gtmap.estateplat.core.support.mybatis.page.helper.DialectHelper;
import cn.gtmap.estateplat.core.support.mybatis.page.helper.SqlHelper;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.util.PatternMatchUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
implements Interceptor {
    private static final int MAPPED_STATEMENT_INDEX = 0;
    private static final int PARAMETER_INDEX = 1;
    private static final int ROWBOUNDS_INDEX = 2;
    private static final int RESULT_HANDLER_INDEX = 3;
    private static final ThreadLocal<Integer> PAGINATION_TOTAL = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private Dialect dialect;
    private String mappedStatementIdRegex;

    public static int getPaginationTotal() {
        return PAGINATION_TOTAL.get();
    }

    public static void clean() {
        PAGINATION_TOTAL.remove();
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] queryArgs = invocation.getArgs();
        MappedStatement ms = (MappedStatement)queryArgs[0];
        Object parameter = queryArgs[1];
        RowBounds rowBounds = (RowBounds)queryArgs[2];
        int offset = rowBounds.getOffset();
        int limit = rowBounds.getLimit();
        boolean intercept = PatternMatchUtils.simpleMatch((String)this.mappedStatementIdRegex, (String)ms.getId());
        if (intercept && this.dialect.supportsLimit() && (offset != 0 || limit != Integer.MAX_VALUE)) {
            BoundSql boundSql = ms.getBoundSql(parameter);
            String sql = boundSql.getSql().trim();
            Executor executor = (Executor)invocation.getTarget();
            Connection connection = executor.getTransaction().getConnection();
            int count = SqlHelper.getCount(ms, connection, parameter, this.dialect);
            PAGINATION_TOTAL.set(count);
            String limitSql = this.dialect.getLimitString(sql, offset, limit);
            MappedStatement newMs = this.newMappedStatement(ms, boundSql, limitSql);
            queryArgs[2] = new RowBounds(0, Integer.MAX_VALUE);
            queryArgs[0] = newMs;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectClass = properties.getProperty("dialectClass");
        if (StringUtils.isBlank((CharSequence)dialectClass)) {
            String dialectShortName = properties.getProperty("dialect");
            this.checkDialect(dialectShortName);
            this.dialect = DialectHelper.getDialect(DatabaseDialectShortName.valueOf(dialectShortName.toUpperCase()));
        } else {
            try {
                this.dialect = (Dialect)Class.forName(dialectClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Plug-in [PaginationInterceptor] cannot create dialect instance by dialectClass: " + dialectClass);
            }
        }
        this.mappedStatementIdRegex = properties.getProperty("stmtIdRegex", "*.*ByPage");
    }

    private void checkDialect(String dialectShortName) {
        try {
            DatabaseDialectShortName.valueOf(dialectShortName.toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException("Plug-in [PaginationInterceptor] the dialect of the attribute value is invalid!");
        }
    }

    private MappedStatement newMappedStatement(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = this.newBoundSql(ms, boundSql, sql);
        RawSqlSource sqlSource = new RawSqlSource(newBoundSql);
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), (SqlSource)sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        String[] keyProperties = ms.getKeyProperties();
        builder.keyProperty(keyProperties == null ? null : keyProperties[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private BoundSql newBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    public class RawSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public RawSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

