package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 农用地使用权（非林地）
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "QLF_QL_NYDSYQ")
public class QlfQlNydsyq implements Serializable, AccessData {
    final static String ysdm = "6002020500";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String zl;//坐落
    //    private String fbfdm;//发包方代码
    private String fbfmc;//发包方名称
    private Double cbmj;//承包（使用权）面积
    private Date cbqssj;//承包（使用）起始时间
    private Date cbjssj;//承包（使用）结束时间
    private String tdsyqxz;//土地所有权性质
    private String syttlx;//水域滩涂类型
    private String yzyfs;//养殖业方式
    private String cyzl;//草原质量
    private Integer syzcl;//适宜载畜量
    private String bdcqzh;//不动产权证号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "ZL")
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    //    @XmlAttribute(name="FBFDM")
    //    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    //    public String getFbfdm() {
    //        return fbfdm;
    //    }
    //
    //    public void setFbfdm(String fbfdm) {
    //        this.fbfdm = fbfdm;
    //    }
    @XmlAttribute(name = "FBF")//xml里只有FBF
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFbfmc() {
        return fbfmc;
    }

    public void setFbfmc(String fbfmc) {
        this.fbfmc = fbfmc;
    }

    @XmlAttribute(name = "CBSYQMJ")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getCbmj() {
        return cbmj;
    }

    public void setCbmj(Double cbmj) {
        this.cbmj = cbmj;
    }

    @XmlAttribute(name = "CBQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getCbqssj() {
        return cbqssj;
    }

    public void setCbqssj(Date cbqssj) {
        this.cbqssj = cbqssj;
    }

    @XmlAttribute(name = "CBJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getCbjssj() {
        return cbjssj;
    }

    public void setCbjssj(Date cbjssj) {
        this.cbjssj = cbjssj;
    }

    @XmlAttribute(name = "TDSYQXZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getTdsyqxz() {
        return tdsyqxz;
    }

    public void setTdsyqxz(String tdsyqxz) {
        this.tdsyqxz = tdsyqxz;
    }

    @XmlAttribute(name = "SYTTLX")
    public String getSyttlx() {
        return syttlx;
    }

    public void setSyttlx(String syttlx) {
        this.syttlx = syttlx;
    }

    @XmlAttribute(name = "YZYFS")
    public String getYzyfs() {
        return yzyfs;
    }

    public void setYzyfs(String yzyfs) {
        this.yzyfs = yzyfs;
    }

    @XmlAttribute(name = "CYZL")
    public String getCyzl() {
        return cyzl;
    }

    public void setCyzl(String cyzl) {
        this.cyzl = cyzl;
    }

    @XmlAttribute(name = "SYZCL")
    public Integer getSyzcl() {
        return syzcl;
    }

    public void setSyzcl(Integer syzcl) {
        this.syzcl = syzcl;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }
}
