package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 房地产权_独幢、层、套、间房屋信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLT_FW_FDCQ_YZ")
public class QltFwFdcqYz implements Serializable, AccessData {
    final static String ysdm = "6002010200";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String fdzl;//房地坐落
    private String tdsyqr;//土地使用权人
    private Double dytdmj;//独用土地面积
    private Double fttdmj;//分摊使用面积
    private Date tdsyqssj;//土地使用起始时间
    private Date tdsyjssj;//土地使用结束时间
    private Double fdcjyjg;//房地产交易价格
    private String ghyt;//规划用途
    private String fwxz;//房屋性质
    private String fwjg;//房屋结构
    private Integer szc;//所在层
    private Integer zcs;//总层数
    private Double jzmj;//建筑面积
    private Double zyjzmj;//专有建筑面积
    private Double ftjzmj;//分摊建筑面积
    private Date jgsj;//竣工时间
    private String bdcqzh;//不动产权证号
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String szmyc;//所在名义层
    private String myzcs;//名义总层数

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }
    @XmlTransient
    public String getMyzcs() {
        return myzcs;
    }

    public void setMyzcs(String myzcs) {
        this.myzcs = myzcs;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
    @XmlTransient
    public String getSzmyc() {
        return szmyc;
    }

    public void setSzmyc(String szmyc) {
        this.szmyc = szmyc;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "FDZL")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFdzl() {
        return fdzl;
    }

    public void setFdzl(String fdzl) {
        this.fdzl = fdzl;
    }

    @XmlAttribute(name = "TDSYQR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getTdsyqr() {
        return tdsyqr;
    }

    public void setTdsyqr(String tdsyqr) {
        this.tdsyqr = tdsyqr;
    }

    @XmlAttribute(name = "DYTDMJ")
    public Double getDytdmj() {
        return dytdmj;
    }

    public void setDytdmj(Double dytdmj) {
        this.dytdmj = dytdmj;
    }

    @XmlAttribute(name = "FTTDMJ")
    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    @XmlAttribute(name = "TDSYQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getTdsyqssj() {
        return tdsyqssj;
    }

    public void setTdsyqssj(Date tdsyqssj) {
        this.tdsyqssj = tdsyqssj;
    }

    @XmlAttribute(name = "TDSYJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getTdsyjssj() {
        return tdsyjssj;
    }

    public void setTdsyjssj(Date tdsyjssj) {
        this.tdsyjssj = tdsyjssj;
    }

    @XmlAttribute(name = "FDCJYJG")
    public Double getFdcjyjg() {
        return fdcjyjg;
    }

    public void setFdcjyjg(Double fdcjyjg) {
        this.fdcjyjg = fdcjyjg;
    }

    @XmlAttribute(name = "GHYT")
    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    @XmlAttribute(name = "FWXZ")
    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }

    @XmlAttribute(name = "FWJG")
    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }

    @XmlAttribute(name = "SZC")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getSzc() {
        return szc;
    }

    public void setSzc(Integer szc) {
        this.szc = szc;
    }

    @XmlAttribute(name = "ZCS")
    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    @XmlAttribute(name = "JZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

    @XmlAttribute(name = "ZYJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getZyjzmj() {
        return zyjzmj;
    }

    public void setZyjzmj(Double zyjzmj) {
        this.zyjzmj = zyjzmj;
    }

    @XmlAttribute(name = "FTJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getFtjzmj() {
        return ftjzmj;
    }

    public void setFtjzmj(Double ftjzmj) {
        this.ftjzmj = ftjzmj;
    }

    @XmlAttribute(name = "JGSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getJgsj() {
        return jgsj;
    }

    public void setJgsj(Date jgsj) {
        this.jgsj = jgsj;
    }
}
