package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/5/4
 * @description 中国移动短信服务
 */
public class CmccSmsServiceImpl implements SmsService {
    private static final String PHONE_NUMBER_NULL="电话号码为空！";
    private static final String CONTENT_NUMBER_NULL="短信内容为空！";
    private static final String REQDELIVERYREPORT_NO_NUMBER="需要状态报告不是数字！";
    private static final String MSGFMT_NO_NUMBER="消息类型不是数字！";
    private static final String SENDMETHOD_NO_NUMBER="短信发送形式不是数字！";
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 扩展号码
     */
    private String extCode;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 是否需要状态报告 0:不需要 1:需要
     */
    private String reqDeliveryReport;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 消息类型
     */
    private String msgFmt;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 短信发送形式
     */
    private String sendMethod;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 短信应用ID
     */
    private String applicationId;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description jdbc连接对象
     */
    private JdbcTemplate jdbcTemplate;

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getExtCode() {
        return extCode;
    }

    public void setExtCode(String extCode) {
        this.extCode = extCode;
    }

    public String getReqDeliveryReport() {
        return reqDeliveryReport;
    }

    public void setReqDeliveryReport(String reqDeliveryReport) {
        this.reqDeliveryReport = reqDeliveryReport;
    }

    public String getMsgFmt() {
        return msgFmt;
    }

    public void setMsgFmt(String msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getSendMethod() {
        return sendMethod;
    }

    public void setSendMethod(String sendMethod) {
        this.sendMethod = sendMethod;
    }

    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 发送短信
     */
    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if(StringUtils.isBlank(phoneNum))
            throw new AppException(PHONE_NUMBER_NULL);
        if(StringUtils.isBlank(content))
            throw new AppException(CONTENT_NUMBER_NULL);
        if(StringUtils.isNumeric(reqDeliveryReport))
            throw new AppException(REQDELIVERYREPORT_NO_NUMBER);
        if(StringUtils.isNumeric(msgFmt))
            throw new AppException(MSGFMT_NO_NUMBER);
        if(StringUtils.isNumeric(sendMethod))
            throw new AppException(SENDMETHOD_NO_NUMBER);

        String sql = "INSERT INTO sms_outbox (SISMSID, EXTCODE, DESTADDR,MESSAGECONTENT, REQDELIVERYREPORT, MSGFMT, SENDMETHOD," +
                " REQUESTTIME, APPLICATIONID) VALUES (?,?,?,?,?,?,?,?,?)";
        try {
            Object[] param = new Object[9];
            param[0]= UUIDGenerator.generate18();
            param[1]= extCode;
            param[2]= phoneNum;
            param[3]= content;
            param[4]= Integer.parseInt(reqDeliveryReport);
            param[5]= Integer.parseInt(msgFmt);
            param[6]= Integer.parseInt(sendMethod);
            param[7]= CalendarUtil.getCurHMSDate();
            param[8]= applicationId;
            jdbcTemplate.update(sql,param);
        }catch (Exception e){
            throw new AppException(e.getMessage());
        }
        return true;
    }

}
