package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/5/4
 * @description 中国移动短信服务
 */
public class CmccSmsServiceImpl implements SmsService {
    private static final String PHONE_NUMBER_NULL="电话号码为空！";
    private static final String CONTENT_NUMBER_NULL="短信内容为空！";
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 扩展号码
     */
    private String extCode;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 是否需要状态报告 0:不需要 1:需要
     */
    private int reqDeliveryReport;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 消息类型
     */
    private int msgFmt;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @description 短信发送形式
     */
    private int sendMethod;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 短信应用ID
     */
    private String applicationId;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description jdbc连接对象
     */
    private JdbcTemplate jdbcTemplate;

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getExtCode() {
        return extCode;
    }

    public void setExtCode(String extCode) {
        this.extCode = extCode;
    }

    public int getReqDeliveryReport() {
        return reqDeliveryReport;
    }

    public void setReqDeliveryReport(int reqDeliveryReport) {
        this.reqDeliveryReport = reqDeliveryReport;
    }

    public int getMsgFmt() {
        return msgFmt;
    }

    public void setMsgFmt(int msgFmt) {
        this.msgFmt = msgFmt;
    }

    public int getSendMethod() {
        return sendMethod;
    }

    public void setSendMethod(int sendMethod) {
        this.sendMethod = sendMethod;
    }

    /**
     * @param phoneNum 手机号
     * @param content  内容
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 发送短信
     */
    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if(StringUtils.isBlank(phoneNum))
            throw new AppException(PHONE_NUMBER_NULL);
        if(StringUtils.isBlank(content))
            throw new AppException(CONTENT_NUMBER_NULL);
        String sql = "INSERT INTO sms_outbox (SISMSID, EXTCODE, DESTADDR,MESSAGECONTENT, REQDELIVERYREPORT, MSGFMT, SENDMETHOD," +
                " REQUESTTIME, APPLICATIONID) VALUES (?,?,?,?,?,?,?,?,?)";
        try {
            Object[] param = new Object[9];
            param[0]= UUIDGenerator.generate18();
            param[1]= extCode;
            param[2]= phoneNum;
            param[3]= content;
            param[4]= reqDeliveryReport;
            param[5]= msgFmt;
            param[6]= sendMethod;
            param[7]= CalendarUtil.getCurHMSDate();
            param[8]= applicationId;
            jdbcTemplate.update(sql,param);
        }catch (Exception e){
            throw new AppException(e.getMessage());
        }
        return true;
    }

}
