/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     JSONMethod.java
 * Modifier: yangxin
 * Modified: 2014-06-25 17:20
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.estateplat.core.support.freemarker.method;

import cn.gtmap.estateplat.core.support.freemarker.FmUtils;
import cn.gtmap.estateplat.utils.RequestUtils;
import com.google.common.collect.Lists;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;

import java.util.List;

/**
 * json函数,参数转化为json
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-25
 */
public class JSONMethod implements TemplateMethodModelEx {
    @Override
    public Object exec(List args) throws TemplateModelException {
        int len = args.size();
        switch (len) {
            case 0:
                return "{}";
            case 1:
                return RequestUtils.toJSON(FmUtils.unwrap(args.get(0)));
            default:
                List<Object> list = Lists.newArrayList();
                for (Object arg : args) {
                    list.add(FmUtils.unwrap(arg));
                }
                return RequestUtils.toJSON(list);
        }
    }
}
