/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.sms.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.sms.SmsService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class CmccSmsServiceImpl
implements SmsService {
    private static final String PHONE_NUMBER_NULL = "\u7535\u8bdd\u53f7\u7801\u4e3a\u7a7a\uff01";
    private static final String CONTENT_NUMBER_NULL = "\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a\uff01";
    private String applicationId;
    private JdbcTemplate jdbcTemplate;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Boolean sendSms(String phoneNum, String content) throws AppException {
        if (StringUtils.isBlank((CharSequence)phoneNum)) {
            throw new AppException(PHONE_NUMBER_NULL);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new AppException(CONTENT_NUMBER_NULL);
        }
        String sql = "INSERT INTO sms_outbox (SISMSID, EXTCODE, DESTADDR,MESSAGECONTENT, REQDELIVERYREPORT, MSGFMT, SENDMETHOD, REQUESTTIME, APPLICATIONID) VALUES (?,?,?,?,?,?,?,?,?)";
        try {
            Object[] param = new Object[]{UUIDGenerator.generate18(), "", phoneNum, content, 0, 15, 2, CalendarUtil.getCurHMSDate(), this.applicationId};
            this.jdbcTemplate.update(sql, param);
        }
        catch (Exception e) {
            throw new AppException(e.getMessage());
        }
        return true;
    }
}

