package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 异议登记信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "QLF_QL_YYDJ")
public class QlfQlYydj implements Serializable, AccessData {
    final static String ysdm = "6002040200";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String yysx;//异议事项
    private String bdcdjzmh;//不动产登记证明号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String zxyyywh;//注销异议业务号
    private String zxyyyy;//注销异议原因
    private String zxyydbr;//注销异议登簿人
    private Date zxyydjsj;//注销异议登记时间
    private String fj;//附记
    private String qszt;//权属状态
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YYSX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYysx() {
        return yysx;
    }

    public void setYysx(String yysx) {
        this.yysx = yysx;
    }

    @XmlAttribute(name = "BDCDJZMH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getBdcdjzmh() {
        return bdcdjzmh;
    }

    public void setBdcdjzmh(String bdcdjzmh) {
        this.bdcdjzmh = bdcdjzmh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "ZXYYYWH")
    public String getZxyyywh() {
        return zxyyywh;
    }

    public void setZxyyywh(String zxyyywh) {
        this.zxyyywh = zxyyywh;
    }

    @XmlAttribute(name = "ZXYYYY")
    public String getZxyyyy() {
        return zxyyyy;
    }

    public void setZxyyyy(String zxyyyy) {
        this.zxyyyy = zxyyyy;
    }

    @XmlAttribute(name = "ZXYYDBR")
    public String getZxyydbr() {
        return zxyydbr;
    }

    public void setZxyydbr(String zxyydbr) {
        this.zxyydbr = zxyydbr;
    }

    @XmlAttribute(name = "ZXYYDJSJ")
   // @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getZxyydjsj() {
        return zxyydjsj;
    }

    public void setZxyydjsj(Date zxyydjsj) {
        this.zxyydjsj = zxyydjsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }
}
