/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     NLS.java
 * Modifier: yangxin
 * Modified: 2014-06-11 10:38
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.estateplat.core.i18n;

import java.util.Locale;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 12-8-13
 */
public final class NLS {

    private static MessageProvider messageProvider = null;

    public void setMessageProvider(MessageProvider messageProvider) {
        NLS.messageProvider = messageProvider;
    }

    public static String get(String key) {
        return messageProvider == null ? null : messageProvider.getMessage(key, null, null, null);
    }

    public static String get(String key, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, null, null);
    }

    public static String get(String key, String defaultMessage, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, defaultMessage, null);
    }

    public static String get(String key, String defaultMessage, Locale locale, Object... args) {
        return messageProvider == null ? null : messageProvider.getMessage(key, args, defaultMessage, locale);
    }

}
