package cn.gtmap.estateplat.core.support.mybatis.mapper;

import org.apache.commons.beanutils.Converter;

import java.sql.Blob;
import java.sql.SQLException;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/6/16
 * @description MyBatis的EntityMapper的Blob转换
 */
public class BlobConvert implements Converter {

    public Object convert(Class type, Object value) {
        byte[] result = null;
        if (value == null)
            return null;
        if(value instanceof Blob){
            try {
                Blob blob = (Blob)value;
                result= blob.getBytes(1,(int)(blob.length()));
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }else {
            result = value.toString().getBytes();
            if (result == null || result.length == 0) {
                return null;
            }
        }

        return result;
    }
}
