package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 抵押权
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "QLF_QL_DYAQ")
public class QlfQlDyaq implements Serializable, AccessData {
    final static String ysdm = "6002030100";//要素代码
    private String bdcdyh;//不动产单元号
    private String scywh;//上次业务号
    private String dyjelx;//抵押金额类型
    private String ywh;//业务号
    private String dybdclx;//抵押不动产类型
    private String dyr;//抵押人
    private String dyfs;//抵押方式
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String zjjzwzl;//在建建筑物坐落
    private String zjjzwdyfw;//在建建筑物抵押范围
    private Double bdbzzqse;//被担保主债权数额
    private Date zwlxqssj;//债务履行起始时间
    private Date zwlxjssj;//债务履行结束时间
    private String zgzqqdss;//最高债权确定事实
    private Double zgzqse;//最高债权数额
    private String zxdyywh;//注销抵押业务号
    private String zxdyyy;//注销抵押原因
    private Date zxsj;//注销时间
    private String bdcdjzmh;//不动产登记证明号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    private String ysxkzmh;//预售许可证明号
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public String getYsxkzmh() {
        return ysxkzmh;
    }
    public void setYsxkzmh(String ysxkzmh) {
        this.ysxkzmh = ysxkzmh;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "SCYWH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getScywh() {
        return scywh;
    }

    public void setScywh(String scywh) {
        this.scywh = scywh;
    }

    @XmlAttribute(name = "DYJELX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDyjelx() {
        return dyjelx;
    }

    public void setDyjelx(String dyjelx) {
        this.dyjelx = dyjelx;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "DYBDCLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDybdclx() {
        return dybdclx;
    }

    public void setDybdclx(String dybdclx) {
        this.dybdclx = dybdclx;
    }

    @XmlAttribute(name = "DYR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDyr() {
        return dyr;
    }

    public void setDyr(String dyr) {
        this.dyr = dyr;
    }

    @XmlAttribute(name = "DYFS")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDyfs() {
        return dyfs;
    }

    public void setDyfs(String dyfs) {
        this.dyfs = dyfs;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "ZJJZWZL")
    public String getZjjzwzl() {
        return zjjzwzl;
    }

    public void setZjjzwzl(String zjjzwzl) {
        this.zjjzwzl = zjjzwzl;
    }

    @XmlAttribute(name = "ZJJZWDYFW")
    public String getZjjzwdyfw() {
        return zjjzwdyfw;
    }

    public void setZjjzwdyfw(String zjjzwdyfw) {
        this.zjjzwdyfw = zjjzwdyfw;
    }

    @XmlAttribute(name = "BDBZZQSE")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    @XmlAttribute(name = "ZWLXQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getZwlxqssj() {
        return zwlxqssj;
    }

    public void setZwlxqssj(Date zwlxqssj) {
        this.zwlxqssj = zwlxqssj;
    }

    @XmlAttribute(name = "ZWLXJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getZwlxjssj() {
        return zwlxjssj;
    }

    public void setZwlxjssj(Date zwlxjssj) {
        this.zwlxjssj = zwlxjssj;
    }

    @XmlAttribute(name = "ZGZQQDSS")
    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    @XmlAttribute(name = "ZGZQSE")
    public Double getZgzqse() {
        return zgzqse;
    }

    public void setZgzqse(Double zgzqse) {
        this.zgzqse = zgzqse;
    }

    @XmlAttribute(name = "ZXDYYWH")
    public String getZxdyywh() {
        return zxdyywh;
    }

    public void setZxdyywh(String zxdyywh) {
        this.zxdyywh = zxdyywh;
    }
    @XmlAttribute(name = "ZXDYYY")
    public String getZxdyyy() {
        return zxdyyy;
    }

    public void setZxdyyy(String zxdyyy) {
        this.zxdyyy = zxdyyy;
    }

    @XmlAttribute(name = "ZXSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getZxsj() {
        return zxsj;
    }

    public void setZxsj(Date zxsj) {
        this.zxsj = zxsj;
    }

    @XmlAttribute(name = "BDCDJZMH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getBdcdjzmh() {
        return bdcdjzmh;
    }

    public void setBdcdjzmh(String bdcdjzmh) {
        this.bdcdjzmh = bdcdjzmh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }
}
