package cn.gtmap.estateplat.model.server.core;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/5/27
 * @description 过渡历史抵押登记
 */
@Table(name = "gd_ls_dy")
public class GdLsDy implements Serializable {
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 主键
     */
    @Id
    private String dyid;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 抵押开始日期
     */
    private Date dyksrq;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 抵押结束日期
     */
    private Date dyjsrq;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 抵押方式
     */
    private String dyfs;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 在建建筑物坐落
     */
    private String zjgczl;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 在建建筑物抵押范围
     */
    private String zjgcdyfw;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 最高债权确定事实
     */
    private String zgzqqdss;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 不动产类型
     */
    private String bdclx;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 项目主键
     */
    private String proid;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 抵押证明号
     */
    private String dydjzmh;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 担保范围
     */
    private String dbfw;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 被担保主债权数额（最高债权数额）
     */
    private Double bdbzzqse;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 最高债权确定数额
     */
    private Double zgzqqdse;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 更新日期
     */
    private Date gxrq;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 登记类型
     */
    private String djlx;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 附记
     */
    private String fj;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 创建人ID
     */
    private String cjrid;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 原权证号
     */
    private String yqzh;

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getYqzh() {
        return yqzh;
    }

    public void setYqzh(String yqzh) {
        this.yqzh = yqzh;
    }

    public String getCjrid() {
        return cjrid;
    }

    public void setCjrid(String cjrid) {
        this.cjrid = cjrid;
    }

    public Date getGxrq() {
		return gxrq;
	}

	public void setGxrq(Date gxrq) {
		this.gxrq = gxrq;
	}

	public String getDyid() {
        return dyid;
    }

    public void setDyid(String dyid) {
        this.dyid = dyid;
    }

    public Date getDyksrq() {
        return dyksrq;
    }

    public void setDyksrq(Date dyksrq) {
        this.dyksrq = dyksrq;
    }

    public Date getDyjsrq() {
        return dyjsrq;
    }

    public void setDyjsrq(Date dyjsrq) {
        this.dyjsrq = dyjsrq;
    }

    public String getDyfs() {
        return dyfs;
    }

    public void setDyfs(String dyfs) {
        this.dyfs = dyfs;
    }

    public String getZjgczl() {
        return zjgczl;
    }

    public void setZjgczl(String zjgczl) {
        this.zjgczl = zjgczl;
    }

    public String getZjgcdyfw() {
        return zjgcdyfw;
    }

    public void setZjgcdyfw(String zjgcdyfw) {
        this.zjgcdyfw = zjgcdyfw;
    }

    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public Double getZgzqqdse() {
        return zgzqqdse;
    }

    public void setZgzqqdse(Double zgzqqdse) {
        this.zgzqqdse = zgzqqdse;
    }

    public String getDydjzmh() {
        return dydjzmh;
    }

    public void setDydjzmh(String dydjzmh) {
        this.dydjzmh = dydjzmh;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getDbfw() {
        return dbfw;
    }

    public void setDbfw(String dbfw) {
        this.dbfw = dbfw;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }
}
