/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.log;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.log.AuditLog;
import cn.gtmap.estateplat.log.AuditLogService;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.data.domain.Pageable;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Aspect
public class AuditLogAspect {
    private AuditLogService auditLogService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String ANONYMOUS_USER_ID = "-999";
    private static final String ANONYMOUS_USER_NAME = "\u533f\u540d\u7528\u6237";

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @Pointcut(value="@annotation(cn.gtmap.estateplat.log.AuditLog)")
    public void auditLogServiceAspect() {
    }

    @Before(value="auditLogServiceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        AuditLog auditMethodLog = this.getMethodLog(joinPoint);
        this.auditLog(auditMethodLog.name(), this.getAuditContent(joinPoint, auditMethodLog));
    }

    @After(value="auditLogServiceAspect()")
    public void doAfter(JoinPoint joinPoint) {
    }

    private void auditLog(String name, String content) {
        final BdcXtLog bdcXtLog = new BdcXtLog();
        bdcXtLog.setLogid(UUIDGenerator.generate());
        bdcXtLog.setCzrq(Calendar.getInstance().getTime());
        if (StringUtils.isNotBlank((CharSequence)SessionUtil.getCurrentUserId())) {
            bdcXtLog.setUserid(SessionUtil.getCurrentUserId());
            bdcXtLog.setUsername(SessionUtil.getCurrentUser().getUsername());
        } else {
            bdcXtLog.setUserid(ANONYMOUS_USER_ID);
            bdcXtLog.setUsername(ANONYMOUS_USER_NAME);
        }
        bdcXtLog.setController(name);
        bdcXtLog.setParmjson(content);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                AuditLogAspect.this.auditLogService.saveAuditLog(bdcXtLog);
            }
        });
    }

    private AuditLog getMethodLog(JoinPoint joinPoint) {
        try {
            Method[] methods;
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                Class<?>[] clazzs;
                if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
                return method.getAnnotation(AuditLog.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AppException(e.getMessage());
        }
        return null;
    }

    private String getAuditContent(JoinPoint joinPoint, AuditLog auditLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = null;
        description = StringUtils.isNotBlank((CharSequence)auditLog.description()) ? auditLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
        contentMap.put(description, this.filterArguments(joinPoint.getArgs()));
        return JSON.toJSONString((Object)contentMap);
    }

    private Object filterArguments(Object[] args) {
        ArrayList arguments = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof Model || arg instanceof Pageable || arg instanceof RedirectAttributes || arg instanceof HttpServletResponse || arg instanceof HttpServletRequest) continue;
            arguments.add(arg);
        }
        return arguments;
    }
}

