/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import cn.gtmap.estateplat.model.server.core.PublicEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtil<T> {
    public static String formatEmptyValue(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String formatNumber(Double value) {
        if (value == null || value.equals("")) {
            value = 0.0;
        }
        DecimalFormat df = new DecimalFormat("##############0.0");
        String value1 = df.format(value);
        return value1;
    }

    public static List<PublicEntity> getChildPublicVo(List<PublicEntity> publicVoList, String parentId) {
        ArrayList<PublicEntity> publicVoList1 = new ArrayList<PublicEntity>();
        if (publicVoList == null || publicVoList.size() == 0) {
            return publicVoList1;
        }
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return publicVoList;
        }
        for (PublicEntity publicVo : publicVoList) {
            if (publicVo == null || !StringUtils.equals((CharSequence)publicVo.getParentId(), (CharSequence)parentId)) continue;
            publicVoList1.add(publicVo);
        }
        return publicVoList1;
    }

    public static List<PublicEntity> getParentPublicVo(List<PublicEntity> publicVoList) {
        ArrayList<PublicEntity> publicVoList1 = new ArrayList<PublicEntity>();
        if (publicVoList == null || publicVoList.size() == 0) {
            return publicVoList1;
        }
        for (PublicEntity publicVo : publicVoList) {
            if (publicVo == null || !StringUtils.isBlank((CharSequence)publicVo.getParentId())) continue;
            publicVoList1.add(publicVo);
        }
        return publicVoList1;
    }

    public static Double formatTwoNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.00");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    public static String[] formatStrToList(String value) {
        String[] retValue = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = value.replaceAll("\\[", "");
            value = value.replaceAll("\\]", "");
            value = value.replaceAll("\\\"", "");
            retValue = value.split(",");
        }
        return retValue;
    }

    public static String paseChinaNum(int value) {
        String chinaNum = "";
        char[] valueStr = (value + "").toCharArray();
        char[] SCDigits = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
        if (valueStr != null && valueStr.length == 2) {
            chinaNum = valueStr[0] == '\u0001' ? "\u5341" + SCDigits[Integer.parseInt(valueStr[1] + "")] : SCDigits[Integer.parseInt(valueStr[0] + "")] + "\u5341" + SCDigits[Integer.parseInt(valueStr[1] + "")];
        } else if (valueStr != null && valueStr.length == 1) {
            chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "";
        }
        return chinaNum;
    }

    public static String getArchiveId(String xml) {
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        SAXBuilder sb = new SAXBuilder();
        String archiveProjectId = null;
        try {
            Document doc = sb.build(source);
            Element root = doc.getRootElement();
            Element result = root.getChild("archive");
            if (result.getAttributeValue("result") != null && result.getAttributeValue("result").equals("succeed")) {
                Element archive = root.getChild("archive");
                List field = archive.getChildren("field");
                Element fieldId = (Element)field.get(field.size() - 3);
                archiveProjectId = fieldId.getText();
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return archiveProjectId;
    }

    public static String getArchiveMsg(String xml) {
        String msg = null;
        try {
            StringReader read;
            InputSource source;
            SAXBuilder sb;
            Document doc;
            Element root;
            Element result;
            if (xml != null && !xml.equals("") && (result = (root = (doc = (sb = new SAXBuilder()).build(source = new InputSource(read = new StringReader(xml)))).getRootElement()).getChild("archive")).getAttributeValue("msg") != null) {
                msg = result.getAttributeValue("msg");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static String getZszt(String zszt) {
        String zt = "";
        zt = StringUtils.equals((CharSequence)zszt, (CharSequence)"2") ? "\u5df2\u8f6c\u79fb" : (StringUtils.equals((CharSequence)zszt, (CharSequence)"3") ? "\u5df2\u53d8\u66f4" : (StringUtils.equals((CharSequence)zszt, (CharSequence)"4") ? "\u5df2\u67e5\u5c01" : "\u6b63\u5e38"));
        return zt;
    }

    public static String readRequestJsonData(HttpServletRequest request) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String reqBody = sb.toString();
        reqBody = URLDecoder.decode(reqBody, "UTF-8");
        reqBody = reqBody.replace("'", "\"");
        reqBody = reqBody.toLowerCase();
        return reqBody;
    }

    public static Map JsonToMapData(String jsonData, String tblkey) {
        JSONObject mapJson = JSON.parseObject((String)jsonData);
        Map tempMap = (Map)mapJson.get(tblkey);
        return tempMap;
    }

    public static void mapBind(Map map, Object pmsVo) {
        Class<?> newClass = pmsVo.getClass();
        Field[] fs = newClass.getDeclaredFields();
        String methodName = null;
        Object mapValue = null;
        String parameterType = null;
        Class[] parameterTypes = new Class[1];
        Object[] args = new Object[1];
        for (String key : map.keySet()) {
            if (key == null) continue;
            for (int i = 0; i < fs.length; ++i) {
                if (!key.equals(fs[i].getName())) continue;
                methodName = "set" + key.replaceFirst(key.substring(0, 1), key.substring(0, 1).toUpperCase());
                try {
                    parameterTypes[0] = fs[i].getType();
                    parameterType = parameterTypes[0].toString();
                    Method method = newClass.getDeclaredMethod(methodName, parameterTypes);
                    mapValue = map.get(key);
                    if (parameterTypes[0] == Integer.class || parameterTypes[0] == Integer.TYPE) {
                        args[0] = mapValue instanceof Integer ? mapValue : Integer.valueOf(Integer.parseInt(mapValue));
                    } else if (parameterTypes[0] == Date.class) {
                        if (mapValue instanceof Date) {
                            args[0] = mapValue;
                        } else {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            args[0] = sdf.parse(mapValue);
                        }
                    } else if (parameterTypes[0] == Double.TYPE || parameterTypes[0] == Double.class) {
                        args[0] = mapValue instanceof Double ? mapValue : Double.valueOf(Double.parseDouble(mapValue));
                    } else if (parameterTypes[0] == String.class) {
                        if (mapValue instanceof String[]) {
                            String[] tempArray = mapValue;
                            String result = "";
                            for (int m = 0; m < tempArray.length; ++m) {
                                result = result + tempArray[m] + ",";
                            }
                            result = result.substring(0, result.length() - 1);
                            args[0] = result;
                        } else {
                            args[0] = mapValue;
                        }
                    } else {
                        args[0] = mapValue;
                    }
                    method.invoke(pmsVo, args);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getBdclx(String bdclxDm) {
        String bdclx = "";
        if (bdclxDm != null && bdclxDm != "") {
            if (bdclxDm.indexOf("TD") > -1) {
                bdclx = bdclxDm.indexOf("FW") > -1 ? "\u571f\u5730\u3001\u623f\u5c4b\u7b49\u5efa\u7b51\u7269" : (bdclxDm.indexOf("GZW") > -1 ? "\u571f\u5730\u3001\u6784\u7b51\u7269" : (bdclxDm.indexOf("SL") > -1 ? "\u571f\u5730\u3001\u68ee\u6797\u3001\u6797\u6728" : (bdclxDm.indexOf("QT") > -1 ? "\u571f\u5730\u3001\u5176\u4ed6" : "\u571f\u5730")));
            } else if (bdclxDm.indexOf("HY") > -1) {
                bdclx = bdclxDm.indexOf("FW") > -1 ? "\u6d77\u57df\u3001\u623f\u5c4b\u7b49\u5efa\u7b51\u7269" : (bdclxDm.indexOf("GZW") > -1 ? "\u6d77\u57df\u3001\u6784\u7b51\u7269" : (bdclxDm.indexOf("WJM") > -1 ? "\u6d77\u57df\u3001\u65e0\u5c45\u6c11\u6d77\u5c9b" : (bdclxDm.indexOf("SL") > -1 ? "\u6d77\u57df\u3001\u68ee\u6797\u3001\u6797\u6728" : (bdclxDm.indexOf("QT") > -1 ? "\u6d77\u57df\u3001\u5176\u4ed6" : "\u6d77\u57df"))));
            }
        }
        return bdclx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] changeImgSize(byte[] data, int nw, int nh) {
        byte[] newdata = null;
        BufferedImage bis = null;
        ByteArrayOutputStream baos = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            bis = ImageIO.read(is);
            int w = bis.getWidth();
            int h = bis.getHeight();
            double sx = (double)nw / (double)w;
            double sy = (double)nh / (double)h;
            AffineTransform transform = new AffineTransform();
            transform.setToScale(sx, sy);
            AffineTransformOp ato = new AffineTransformOp(transform, null);
            BufferedImage bid = new BufferedImage(nw, nh, 5);
            ato.filter(bis, bid);
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bid, "jpeg", baos);
            newdata = baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != bis) {
                bis = null;
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpConnect(String url) {
        String json = "";
        HttpURLConnection huc = null;
        try {
            huc = (HttpURLConnection)new URL(url).openConnection();
            huc.setReadTimeout(3000);
            huc.setConnectTimeout(3000);
            huc.setRequestMethod("GET");
            InputStream is = huc.getInputStream();
            if (is != null) {
                json = IOUtils.toString((InputStream)is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (huc != null) {
                huc.disconnect();
            }
        }
        return json;
    }

    public static String addBigDecimal(Object aa, Object bb) {
        BigDecimal rs = new BigDecimal(0);
        if (aa != null && !"".equals(aa)) {
            rs = rs.add(new BigDecimal(aa.toString()));
        }
        if (bb != null && !"".equals(bb)) {
            rs = rs.add(new BigDecimal(bb.toString()));
        }
        if (rs.toString().equals("0")) {
            return "0";
        }
        return rs.toString();
    }

    public static boolean indexOfStrs(String[] a, String b) {
        boolean msg = false;
        if (a != null) {
            for (String c : a) {
                if (!StringUtils.equals((CharSequence)c, (CharSequence)b)) continue;
                msg = true;
                break;
            }
        }
        return msg;
    }

    public static Double getGybl(String qlblStr) {
        Double qlbl = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)qlblStr)) {
                if (qlblStr.indexOf("%") > -1) {
                    qlblStr = qlblStr.replaceAll("%", "");
                    qlbl = Double.parseDouble(qlblStr) / 100.0;
                } else {
                    qlbl = Double.parseDouble(qlblStr);
                    if (qlbl > 1.0) {
                        qlbl = qlbl / 100.0;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qlbl;
    }

    public static long getDaySub(Date beginDateStr, Date endDateStr) {
        long day = 0L;
        day = (endDateStr.getTime() - beginDateStr.getTime()) / 86400000L;
        return ++day;
    }

    public static Date plusDay(Date SourceDate, int day) {
        SourceDate.setDate(SourceDate.getDate() + day);
        return SourceDate;
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public List<T> getDataFromList(List baseDataList, T entityClass) {
        ArrayList getBaseDataList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)baseDataList)) {
            for (Object baseData : baseDataList) {
                if (baseData == null || !baseData.getClass().isInstance(entityClass)) continue;
                getBaseDataList.add(baseData);
            }
        }
        return getBaseDataList;
    }
}

