/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.mq;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonMessageConverter
extends AbstractJsonMessageConverter {
    private static Log log = LogFactory.getLog(FastJsonMessageConverter.class);

    protected Message createMessage(Object object, MessageProperties messageProperties) {
        byte[] bytes = null;
        try {
            String jsonString = JSON.toJSONString((Object)object);
            bytes = jsonString.getBytes(this.getDefaultCharset());
        }
        catch (IOException e) {
            throw new MessageConversionException("Failed to convert Message content", (Throwable)e);
        }
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding(this.getDefaultCharset());
        if (bytes != null) {
            messageProperties.setContentLength((long)bytes.length);
        }
        this.getClassMapper().fromClass(object.getClass(), messageProperties);
        return new Message(bytes, messageProperties);
    }

    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.contains("json")) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.getDefaultCharset();
                }
                try {
                    Class targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                    content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
                }
                catch (IOException e) {
                    throw new MessageConversionException("Failed to convert Message content", (Throwable)e);
                }
            } else {
                log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "]"));
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object convertBytesToObject(byte[] body, String encoding, Class<?> targetClass) throws UnsupportedEncodingException {
        String contentAsString = new String(body, encoding);
        return JSON.parseObject((String)contentAsString, targetClass);
    }
}

