/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.mybatisMapper;

import cn.gtmap.estateplat.core.support.mybatisMapper.BaseProvider;
import cn.gtmap.estateplat.core.support.mybatisMapper.EntityHelper;
import cn.gtmap.estateplat.core.support.mybatisMapper.MapperTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonProvider
extends BaseProvider {
    public String select(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
                StringBuilder orderBy = new StringBuilder();
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.getOrderBy() == null) continue;
                    orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy()).append(",");
                }
                if (orderBy.length() > 0) {
                    this.ORDER_BY(orderBy.substring(0, orderBy.length() - 1));
                }
            }
        }.toString();
    }

    public String count(final Map<String, Object> params) {
        return new SQL(){
            {
                Class<?> entityClass;
                Object entity = CommonProvider.this.getEntity(params);
                if (entity instanceof Class) {
                    entityClass = (Class<?>)entity;
                    entity = null;
                } else {
                    entityClass = CommonProvider.this.getEntityClass(params);
                }
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                if (entity != null) {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        if (value == null) continue;
                        if (column.getJavaType().equals(String.class)) {
                            if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                            this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                            continue;
                        }
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String selectByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), entity);
                    this.WHERE(column.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String insert(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String insertSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.INSERT_INTO(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (!column.isId() && value == null) continue;
                    this.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
                }
            }
        }.toString();
    }

    public String insertBatchSelective(Map<String, Object> params) {
        String insertBatchSql = "";
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        insertBatchSql = insertBatchSql + "insert into " + entityTable.getName();
        if (params.containsKey("record") && params.get("record") != null && (params.get("record") instanceof List || params.get("record") instanceof ArrayList)) {
            List list = (List)params.get("record");
            for (int i = 0; i < list.size(); ++i) {
                String str = "select ";
                MetaObject metaObject = MapperTemplate.forObject(list.get(i));
                int j = 0;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    ++j;
                    Object value = metaObject.getValue(column.getProperty());
                    if (i == 0) {
                        columns.add(column.getColumn());
                    }
                    String type = this.getjdbcType(column.getJavaType().getSimpleName());
                    if (j == entityTable.getEntityClassColumns().size()) {
                        str = str + "#{record[" + i + "]." + column.getProperty() + "," + type + "}";
                        continue;
                    }
                    str = str + "#{record[" + i + "]." + column.getProperty() + "," + type + "},";
                }
                str = str + " from dual";
                values.add(str);
            }
        }
        insertBatchSql = insertBatchSql + " " + this.batchSql(columns, ",");
        insertBatchSql = insertBatchSql + " " + this.batchSql(values, "union all");
        return insertBatchSql;
    }

    private String batchSql(List<?> list, String split) {
        String str = "(";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                str = str + list.get(i) + " ";
                if (list.size() - i == 1) continue;
                str = str + split + " ";
            }
        }
        str = str + ")";
        return str;
    }

    private String getjdbcType(String type) {
        String str = "";
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DATE")) {
            str = "jdbcType=TIME";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"STRING")) {
            str = "jdbcType=VARCHAR";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"INTEGER")) {
            str = "jdbcType=INTEGER";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DOUBLE")) {
            str = "jdbcType=DOUBLE";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"FLOAT")) {
            str = "jdbcType=FLOAT";
        }
        return str;
    }

    public String delete(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.DELETE_FROM(entityTable.getName());
                boolean hasValue = false;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    if (column.getJavaType().equals(String.class)) {
                        if (!CommonProvider.this.isNotEmpty((String)value)) continue;
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                        hasValue = true;
                        continue;
                    }
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    hasValue = true;
                }
                if (!hasValue) {
                    throw new UnsupportedOperationException("delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u5168\u8868\u7684\u64cd\u4f5c!");
                }
            }
        }.toString();
    }

    public String deleteByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), entity);
                    this.WHERE(column.getColumn() + "=#{key}");
                } else {
                    MetaObject metaObject = MapperTemplate.forObject(entity);
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKey(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKeyNull(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    String type = CommonProvider.this.getjdbcType(column.getJavaType().getSimpleName());
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "," + type + "}");
                }
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        Object value = metaObject.getValue(column.getProperty());
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), value);
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String updateByPrimaryKeySelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null || column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                if (entityTable.getEntityClassPKColumns().size() == 1) {
                    EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
                    CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                    this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                } else {
                    for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                        CommonProvider.this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                        this.WHERE(column.getColumn() + "=#{record." + column.getProperty() + "}");
                    }
                }
            }
        }.toString();
    }

    public String countByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT("count(*)");
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String deleteByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.DELETE_FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String selectByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                this.SELECT(EntityHelper.getAllColumns(entityClass));
                this.FROM(entityTable.getName());
                CommonProvider.this.applyWhere(this, example);
                CommonProvider.this.applyOrderBy(this, example);
            }
        }.toString();
    }

    public String updateByExampleSelective(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    Object value = metaObject.getValue(column.getProperty());
                    if (value == null) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }

    public String updateByExample(final Map<String, Object> params) {
        return new SQL(){
            {
                Object entity = CommonProvider.this.getEntity(params);
                MetaObject example = CommonProvider.this.getExample(params);
                Class<?> entityClass = CommonProvider.this.getEntityClass(params);
                EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
                MetaObject metaObject = MapperTemplate.forObject(entity);
                this.UPDATE(entityTable.getName());
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    if (column.isId()) continue;
                    this.SET(column.getColumn() + "=#{record." + column.getProperty() + "}");
                }
                CommonProvider.this.applyWhere(this, example);
            }
        }.toString();
    }
}

