<#--
    用来上传文件的html
    space-文件的空间
    owner-文件的拥有者
-->
<#macro UploadHtml fileInputId space owner>
<script >
    $(document).ready(function() {
        $("#${fileInputId}").uploadify({
            'buttonText' : '选择文件',
            'height' : 20,
            'swf' : '${base}/static/thridparty/uploadify/uploadify.swf',
            'uploader' : '${base}/file/upload?space=${space}&owner=${owner}',
            'width' : 75,
            'auto':false,
            'multi':false,
            'sizeLimit': 500000000,
            'fileObjName': 'file',
            'onUploadSuccess' : function(file, data, response) {
                //alert( file.name + ' 上传成功！ '+response);
                $("input[name='fileId']").val(data);
                try{
                    _UploadFileSuccess();
                }catch(ex) {
                }
            }
        });
    });
</script>
<input type="file" name="fileName" id="${fileInputId}"/>
<p>
    <input type="hidden" name="fileId">
    <a href="javascript:$('#${fileInputId}').uploadify('upload', '*')" style="font-size: 13px">上传文件</a>
    <a href="javascript:$('#${fileInputId}').uploadify('stop')" style="font-size: 13px">停止上传</a>
</p>
</#macro>

<#--
    用来上传图片的html
    space-文件的空间
    owner-文件的拥有者
    imgstyle-图片img样式
    blankSrc--如果没有图片，显示什么图片
-->
<#macro UploadImage fileInputId space owner imgstyle blankSrc>
<script >
    $(document).ready(function() {
        $("#${fileInputId}").uploadify({
            'buttonText' : '选择文件',
            'height' : 20,
            'swf' : '${base}/static/thridparty/uploadify/uploadify.swf',
            'uploader' : '${base}/file/upload?space=${space}&owner=${owner}',
            'width' : 75,
            'auto':true,
            'multi':false,
            'sizeLimit': 50000000,
            'fileObjName': 'file',
            'onUploadSuccess' : function(file, data, response) {
                if (response){
                    $("#${fileInputId}"+"_img").attr("src","${base}/file/view?id="+data);
                    $("#${fileInputId}"+"_img").attr("imgid",data);
                }
            }
        });

        $.get("${base}/file/get?space=${space}&owner=${owner}", function(result){
            if (result && result.length>0){
                $("#${fileInputId}"+"_img").attr("src","${base}/file/view?id="+result[0].id);
                $("#${fileInputId}"+"_img").attr("imgid",result[0].id);
            }
        });
    });
</script>
<img id="${fileInputId}_img" src="${blankSrc}" style="${imgstyle}">
<input type="file" name="fileName" id="${fileInputId}"/>
</#macro>

<#--
    用来生成下载文件的列表
    space-文件的空间
    owner-文件的拥有者
-->
<#macro DownLoadListHTML divId space owner>
<script >
    $(document).ready(function() {
        $("#${divId}").load("${base}/file/list.f?space=${space}&owner=${owner}");
    });
</script>
<div id="${divId}"></div>
</#macro>