<#-- @ftlvariable name="type" type="java.lang.Class" -->
<#-- @ftlvariable name="source" type="com.mapjs.hydroplat.core.ex.Source" -->
<#-- @ftlvariable name="ex" type="com.mapjs.hydroplat.core.ex.AppException" -->
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <title>系统异常 - ${type.simpleName}</title>
    <style type="text/css">
        html, body {
            margin: 0;
            padding: 0;
            font-family: Helvetica, Arial, 'Microsoft YaHei';
            background: #eee;
        }

        .block {
            padding: 20px;
            border-bottom: 1px solid #bbb;
        }

        #header h1 {
            font-weight: normal;
            font-size: 28px;
            margin: 0;
        }

        #header h4 {
            font-weight: normal;
            font-size: 16px;
            margin: 5px 10px;
        }

        #header pre {
            word-wrap: break-word;
            color: #333;
            font-size: 14px;
        }

        #more {
            color: #666;
            font-size: 80%;
            border: none;
        }

        #header {
            background: #fcd2da;
        }

        #header p {
            color: #333;
        }

        #source {
            background: #f6f6f6;
        }

        #source h2 {
            font-weight: normal;
            font-size: 18px;
            margin: 0 0 10px 0;
        }

        #source .lineNumber {
            float: left;
            display: block;
            width: 40px;
            text-align: right;
            margin-right: 10px;
            font-size: 14px;
            font-family: monospace;
            background: #333;
            color: #fff;
        }

        #source .line {
            clear: both;
            color: #333;
            margin-bottom: 1px;
        }

        #source pre {
            font-size: 14px;
            margin: 0;
            overflow-x: hidden;
        }

        #source .error, #source .error a {
            color: #c00 !important;
        }

        #source .error .lineNumber {
            background: #c00;
        }

        #source a {
            text-decoration: none;
            color: #000;
        }

        #source a:hover {
            background: #ddd;
        }

        #source a:hover * {
            cursor: pointer !important;
        }

        #source a:hover pre {
            background: #faffcf !important;
        }

        #source em {
            font-style: normal;
            text-decoration: underline;
            font-weight: bold;
        }

        #source strong {
            font-style: normal;
            font-weight: bold;
        }
    </style>
    <script type="application/javascript">
        function cl(a) {
            document.getElementById('clink').src = a.href;
            return false;
        }
    </script>
</head>
<body>
<img id="clink" style="display: none;"/>
<div id="header" class="block">
    <h1>${source.title!}</h1>
    <h4>${type.simpleName} occurred : ${ex.simpleMessage}</h4>
<#if source.description??>
    <pre>${source.description}</pre>
</#if>
</div>
<#if source.file??>
<div id="source" class="block">
    <h2>In ${source.file!} (around line ${source.lineNumber})</h2>
    <#list source.viewLines as line>${line}</#list>
</div>
</#if>
<div id="more" class="block">
    This exception has been logged with id <strong>${ex.id}</strong>
</div>
</body>
</html>