<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <title>任务办理</title>
    <script type="text/javascript">
    function showInfo(processId){
        var url="${base}/comment.f?id="+ processId;
        $("#divCommentList").load(url,function(){
            $('#infoModal').modal({
                backdrop:false
            });
        });
    }

    $(document).ready(function () {
        $('#userSelect1').select2({
            placeholder: "选择人员",
            minimumInputLength: 1,
            multiple:true,
            ajax: {
                url: "${base}/admin/user-search",
                dataType: 'json',
                quietMillis: 250,
                data: function (term, page) {
                    return {
                        q: term, // search term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.viewName,
                                slug: item.slug,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    });
    </script>
</head>
<body>
<div class="allTop">

    <div class="commonTop row-fluid" style="height: 60px">
        <div style="margin-left:20px;float:left">
            <h4 style="color:#ffffff;margin-bottom:2px">${processInstance.name}</h4>
            <p style="color:#ffffff;">当前活动:${task.name} &nbsp;&nbsp;&nbsp;&nbsp;
                创建时间：${task.createTime?string('yyyy-MM-dd HH:mm')}&nbsp;&nbsp;&nbsp;&nbsp;
                超期时间：<#if task.dueDate??>${task.dueDate?string('yyyy-MM-dd HH:mm')}<#else>无</#if>&nbsp;&nbsp;&nbsp;&nbsp;
                优先级：<#if task.priority < 50>低<#elseif  task.priority=50 >中 <#else>高</#if>&nbsp;&nbsp;&nbsp;&nbsp;
                办理人：<#if task.assignee??>${UserUtil.getUserNameById(task.assignee)}<#else>无</#if>
            </p>
        </div>
        <div style="float:right;margin-top:5px;margin-right:60px">
            <a href="javascript:showInfo('${processInstance.id}')" class="btn " ><i class="icon-warning-sign"></i> 事件</a>
            <@task_buttons taskObj=task />
        </div>
    </div>
</div>
<div id="infoModal" class="modal hide fade" tabindex="-1" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 id="myModalLabel">流程办理信息</h4>
    </div>
    <div class="modal-body" id="divCommentList">
    </div>
</div>



</body>
</html>