<!--
显示task的办理按钮
-->
<#macro task_buttons taskObj>
<script type="text/javascript">
    function beginTurn(taskId){
        $('#divTurns').load("${base}/admin/translist.f?taskId=" + taskId,function(){
            $('#turnModal').modal({
                backdrop:false
            });
        });
    }

    function beginBackTurn(taskId){
        $('#divBackTurns').load("${base}/admin/translist-back.f?taskId=" + taskId,function(){
            $('#turnBackModal').modal({
                backdrop:false
            });
        });
    }

    function claimFunction(taskId){
        $.ajax({
            type: 'POST',
            url: "${base}/claim.f?taskId="+ taskId ,
            success: function(data){
                location.reload();
            }
        });
    }

    function turnFunction(taskId){
        var targetObj={};
        targetObj.comment=$('#comment').val();
        $("#transTable tr").each(function(){
            targetObj.activityModelList=[];
            if ($(this).attr("id")){
                var aModel={id:$(this).attr("id")};
                aModel.userIds=[];
                $(this).find("span").each(function(){
                    aModel.userIds.push($(this).attr("id"));
                });
                targetObj.activityModelList.push(aModel);
            }
        });
        $.ajax({
            type: 'POST',
            contentType: "application/json",
            data: $.toJSON(targetObj),
            url: "${base}/admin/complete.f?taskId=" +taskId ,
            success: function(data){
                if(data=="true"){
                    window.close();
                }else{
                    alert(data);
                }
            }
        });
    }

    function turnBackFunction(taskId){
        var targetObj={};
        targetObj.comment=$('#commentBack').val();
        $("#transBackTable tr").each(function(){
            targetObj.activityModelList=[];
            if ($(this).attr("id")){
                var aModel={id:$(this).attr("id")};
                aModel.userIds=[];
                $(this).find("span").each(function(){
                    aModel.userIds.push($(this).attr("id"));
                });
                targetObj.activityModelList.push(aModel);
            }
        });
        $.ajax({
            type: 'POST',
            contentType: "application/json",
            data: $.toJSON(targetObj),
            url: "${base}/admin/complete-back.f?taskId=" +taskId ,
            success: function(data){
                if(data=="true"){
                    window.close();
                }else{
                    alert(data);
                }
            }
        });
    }

    function showUserLink(){
        $('#userIds').select2({
            minimumInputLength: 1,
            multiple:true,
            ajax: {
                url: "${base}/admin/user-search",
                dataType: 'json',
                quietMillis: 250,
                data: function (term, page) {
                    return {
                        q: term, // search term
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.viewName,
                                slug: item.slug,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
        $('#addUserLinkModal').modal({
            backdrop:false
        });
    }

    function addUserLink(){
        $("#fromAddUserLink").ajaxSubmit({
            type: 'post',
            success: function(data) {
                alert(data);
            }
        });
    }
</script>
<a href="javascript:claimFunction('${taskObj.id}')" class="btn " <#if taskObj.assignee??> disabled="disabled"</#if>><i class="icon-edit"></i> 签收</a>
<a href="javascript:beginBackTurn('${taskObj.id}')" class="btn " <#if !taskObj.assignee??> disabled="disabled"</#if>><i class="icon-backward"></i> 退回</a>
<div class="btn-group" >
    <button class="btn" style="text-shadow:0 0px 0px" <#if !taskObj.assignee??> disabled="disabled"</#if> onclick="beginTurn('${taskObj.id}')"><i class="icon-forward"></i> 转发</button>
    <button class="btn dropdown-toggle" data-toggle="dropdown" <#if !taskObj.assignee??> disabled="disabled"</#if>>
        <span class="caret"></span>
    </button>
    <ul class="dropdown-menu" style="min-width:125px">
        <li><a href="javascript:showUserLink()">添加参与人</a></li>
        <li><a href="#">任务委托</a></li>
    </ul>
</div>
<div id="turnModal" class="modal hide fade" tabindex="-1" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 id="myModalLabel">任务转发</h4>
    </div>
    <div class="modal-body" id="divInfo">
        <div id="divTurns">
        </div>
        <label>办理意见：</label>
        <textarea rows="3" class="span12" id="comment"></textarea>
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary" type="button" onclick="turnFunction('${taskObj.id}')">转发</button>
        <button class="btn" data-dismiss="modal" aria-hidden="true">关闭</button>
    </div>
</div>

<div id="turnBackModal" class="modal hide fade" tabindex="-1" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 id="myModalLabel">任务退回</h4>
    </div>
    <div class="modal-body" id="divBackInfo">
        <div id="divBackTurns">
        </div>
        <label>退回意见：</label>
        <textarea rows="3" class="span12" id="commentBack"></textarea>
    </div>
    <div class="modal-footer">
        <button class="btn btn-primary" type="button" onclick="turnBackFunction('${taskObj.id}')">退回</button>
        <button class="btn" data-dismiss="modal" aria-hidden="true">关闭</button>
    </div>
</div>

<div id="addUserLinkModal" class="modal hide fade" tabindex="-1" >
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        <h4 id="myModalLabel">添加参与人</h4>
    </div>
    <form  id="fromAddUserLink" action="${base}/admin/add-userlink" method="post" class="form-horizontal">
        <div class="modal-body" id="divInfo">
            <label>参与人列表：</label>
            <input class='span12' type='text' placeholder='选择人员' id="userIds" multiple="multiple" name="userIds"/>
            <input type="hidden" name="taskId" value="${taskObj.id}">
        </div>
        <div class="modal-footer">
            <button class="btn btn-primary" type="button" onclick="addUserLink()">添加</button>
            <button class="btn" data-dismiss="modal" aria-hidden="true">关闭</button>
        </div>
    </form>
</div>
</#macro>

