/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security.web;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.Sec;
import cn.gtmap.egovplat.security.SecurityContext;
import cn.gtmap.egovplat.security.SessionProvider;
import cn.gtmap.egovplat.security.ex.NoPermissonException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class SecContextFilter
extends OncePerRequestFilter {
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;
    protected volatile SessionProvider sessionProvider;
    private String[] excludes;
    private String[] needLogins;
    private String redirectUrl;

    @Autowired
    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    protected void initFilterBean() throws ServletException {
        this.initSessionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.initSessionProvider();
        if (RequestUtils.matchAny(request, this.urlPathHelper, this.pathMatcher, this.excludes)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            SecurityContext.getContext().setSession(this.sessionProvider.getSession(request, response));
            if (RequestUtils.matchAny(request, this.urlPathHelper, this.pathMatcher, this.needLogins) && Sec.isGuest()) {
                if (this.redirectUrl == null) throw new NoPermissonException("Need login");
                response.sendRedirect(this.redirectUrl + (this.redirectUrl.contains("?") ? "&" : "?") + "url=" + ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).build().encode());
                return;
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        finally {
            SecurityContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSessionProvider() {
        if (this.sessionProvider == null) {
            SecContextFilter secContextFilter = this;
            synchronized (secContextFilter) {
                WebApplicationContext was;
                if (this.sessionProvider == null && (was = this.getWebApplicationContext(this.getServletContext())) != null) {
                    was.getAutowireCapableBeanFactory().autowireBean((Object)this);
                }
            }
        }
    }

    private WebApplicationContext getWebApplicationContext(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
    }
}

