/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security.impl;

import cn.gtmap.egovplat.core.attr.JSONAttrable;
import cn.gtmap.egovplat.security.Role;
import cn.gtmap.egovplat.security.Session;
import cn.gtmap.egovplat.security.User;
import java.util.Set;

public abstract class AbstractSession
extends JSONAttrable
implements Session {
    private static final long serialVersionUID = -1505702232205092673L;
    private final String token;
    private String globalToken;
    private String userId;
    private Set<Role> roles;
    private User user;

    public AbstractSession(String token) {
        this.token = token;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getGlobalToken() {
        if (this.globalToken == null) {
            this.globalToken = this.internalGetGlobalToken();
        }
        return this.globalToken;
    }

    @Override
    public String getUserId() {
        if (this.userId == null) {
            this.userId = this.internalGetUserId();
        }
        return this.userId;
    }

    @Override
    public Set<Role> getRoles() {
        if (this.roles == null) {
            this.roles = this.internalGetRoles();
        }
        return this.roles;
    }

    @Override
    public User getUser() {
        if (this.user == null) {
            this.user = this.internalGetUser();
        }
        return this.user;
    }

    protected abstract String internalGetGlobalToken();

    protected abstract String internalGetUserId();

    protected abstract Set<Role> internalGetRoles();

    protected abstract User internalGetUser();

    @Override
    public int hashCode() {
        return this.token.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Session && this.token.equals(((Session)obj).getToken());
    }

    @Override
    public String toString() {
        return "[Session token:" + this.token + "]";
    }
}

