/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.core.annotation.Resource;
import cn.gtmap.egovplat.core.bean.Dictable;
import cn.gtmap.egovplat.core.bean.Titleable;
import cn.gtmap.egovplat.core.util.EnumUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Resource(key="Operation", name="\u8d44\u6e90\u64cd\u4f5c")
public enum Operation implements Dictable,
Titleable
{
    NULL("\u7a7a", 0),
    VIEW("\u67e5\u770b", 1),
    EDIT("\u7f16\u8f91", 2),
    ADMIN("\u7ba1\u7406", 4);

    private String title;
    private int code;

    private Operation(String title, int code) {
        this.title = title;
        this.code = code;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public Map<String, String> getItems() {
        return EnumUtils.getDictMap(Operation.class, 1);
    }

    public boolean in(long operations) {
        return (operations & (long)this.code) != 0L;
    }

    public static long toCode(Collection<Operation> operations) {
        long code = 0L;
        for (Operation operation : operations) {
            code |= (long)operation.getCode();
        }
        return code;
    }

    public static List<Operation> getOperations(long operations) {
        ArrayList list = Lists.newArrayList();
        for (Operation op : Operation.values()) {
            if (!op.in(operations)) continue;
            list.add(op);
        }
        return list;
    }
}

