/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.security;

import cn.gtmap.egovplat.security.ex.SecException;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class GlobalToken {
    private String userId;
    private Date expire;
    private Set<String> resources = Sets.newHashSet();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public void addResources(Collection<String> resources) {
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.userId);
        sb.append(",").append(this.expire.getTime());
        for (String res : this.resources) {
            sb.append(",").append(res);
        }
        return sb.toString();
    }

    public static GlobalToken fromString(String s) {
        String[] arr = StringUtils.split((String)s, (char)',');
        if (arr.length < 2) {
            throw new SecException("Invalid global token:[" + s + "]");
        }
        GlobalToken globalToken = new GlobalToken();
        globalToken.setUserId(arr[0]);
        globalToken.setExpire(new Date(Long.valueOf(arr[1])));
        if (arr.length > 2) {
            globalToken.addResources(Arrays.asList(arr).subList(2, arr.length));
        }
        return globalToken;
    }
}

