/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.web;

import cn.gtmap.egovplat.core.data.P;
import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.entity.IdGetter;
import cn.gtmap.egovplat.core.util.ClassUtils;
import cn.gtmap.egovplat.core.util.ExUtils;
import cn.gtmap.egovplat.core.web.BaseController;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class EntityController<E, ID extends Serializable>
extends BaseController {
    private final Class<E> entityClass = ClassUtils.getGenericParameter0(this.getClass());
    @Autowired(required=false)
    private IdGetter<E, ID> idGetter;

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityController() {
        if (!AopUtils.isAopProxy((Object)this) && this.entityClass == null) {
            throw new IllegalArgumentException("Entity class not found");
        }
    }

    @ModelAttribute(value="_model")
    public E getEntity(@RequestParam(value="id", required=false) ID id, Model model) {
        model.addAttribute("ctl", (Object)this);
        if (id == null || "".equals(id)) {
            return this.newEntity();
        }
        return this.loadEntity(id);
    }

    @RequestMapping(value={"list"})
    public String list(Model model, HttpServletRequest request, Pageable pageable) {
        model.addAttribute("page", this.listEntities(request, pageable));
        return this.getView("list");
    }

    @RequestMapping(value={"ajax-list"})
    @ResponseBody
    public Page<E> ajaxList(HttpServletRequest request, Pageable pageable) {
        return this.listEntities(request, pageable);
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.GET})
    public String edit(@ModelAttribute(value="_model") E entity, Model model, HttpServletRequest request) {
        this.prepareEdit(entity, model, request);
        return this.getView("list");
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public String save(@ModelAttribute(value="_model") E entity, HttpServletRequest request) {
        this.saveEntity(entity, request);
        return "redirect:" + this.getView("edit") + "?id=" + this.getEntityId(entity);
    }

    @RequestMapping(value={"ajax-edit"}, method={RequestMethod.POST})
    @ResponseBody
    public E AjaxSave(@ModelAttribute(value="_model") E entity, HttpServletRequest request) {
        this.saveEntity(entity, request);
        return entity;
    }

    @RequestMapping(value={"remove"})
    public String remove(@RequestParam(value="id") ID[] ids, Pageable pageable) {
        this.removeEntities(Arrays.asList(ids));
        String view = "redirect:" + this.getView("list");
        if (pageable != P.DEFAULT) {
            view = view + "?size=" + pageable.getSize() + "&index=" + pageable.getIndex();
        }
        return view;
    }

    @RequestMapping(value={"ajax-remove"})
    @ResponseBody
    public Map ajaxRemove(@RequestParam(value="id") ID[] ids) {
        this.removeEntities(Arrays.asList(ids));
        return EntityController.success();
    }

    protected String getView(String action) {
        return "/" + StringUtils.uncapitalize((String)this.entityClass.getSimpleName()) + "/" + action;
    }

    protected E newEntity() {
        try {
            return this.entityClass.newInstance();
        }
        catch (Exception e) {
            throw ExUtils.wrap(e);
        }
    }

    protected void prepareEdit(E entity, Model model, HttpServletRequest request) {
    }

    protected ID getEntityId(E entity) {
        if (this.idGetter != null) {
            return (ID)((Serializable)this.idGetter.getId(entity));
        }
        throw new UnsupportedOperationException("getEntityId");
    }

    protected abstract Page<E> listEntities(HttpServletRequest var1, Pageable var2);

    protected abstract E loadEntity(ID var1);

    protected abstract void saveEntity(E var1, HttpServletRequest var2);

    protected abstract void removeEntities(List<ID> var1);
}

