/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.validation.interceptor;

import cn.gtmap.egovplat.core.validation.Validate;
import cn.gtmap.egovplat.core.validation.Validator;
import cn.gtmap.egovplat.core.validation.interceptor.AppExceptionTranslator;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.annotation.BeanValidationAnnotationsConfigurer;
import net.sf.oval.configuration.annotation.JPAAnnotationsConfigurer;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.guard.Guard;
import net.sf.oval.guard.GuardInterceptor;
import net.sf.oval.guard.Guarded;
import net.sf.oval.internal.Log;
import net.sf.oval.logging.LoggerFactory;
import net.sf.oval.logging.LoggerFactorySLF4JImpl;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.beans.factory.InitializingBean;

public class ValidationSourceAdvisor
extends AbstractBeanFactoryPointcutAdvisor
implements InitializingBean {
    private static final long serialVersionUID = 8448761854101833695L;
    private Validator validator;
    private ExceptionTranslator exceptionTranslator;
    private LinkedList<Configurer> configurers = new LinkedList();
    private boolean enableAll;
    private final Pointcut pointcut = new StaticMethodMatcherPointcut(){

        public boolean matches(Method method, Class<?> targetClass) {
            return (ValidationSourceAdvisor.this.enableAll || targetClass.isAnnotationPresent(Guarded.class) || targetClass.isAnnotationPresent(Validate.class)) && ValidationSourceAdvisor.this.validator.needValidate(method, targetClass);
        }
    };

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setConfigurers(List<Configurer> configurers) {
        this.configurers.addAll(configurers);
    }

    public void setEnableAll(boolean enableAll) {
        this.enableAll = enableAll;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void afterPropertiesSet() throws Exception {
        Log.setLoggerFactory((LoggerFactory)new LoggerFactorySLF4JImpl());
        if (this.validator == null) {
            this.configurers.addFirst((Configurer)new BeanValidationAnnotationsConfigurer());
            this.configurers.addFirst((Configurer)new JPAAnnotationsConfigurer());
            this.configurers.addFirst((Configurer)new AnnotationsConfigurer());
            this.validator = new Validator(this.configurers);
            if (this.exceptionTranslator == null) {
                this.exceptionTranslator = new AppExceptionTranslator();
            }
            this.validator.setExceptionTranslator(this.exceptionTranslator);
        }
        if (this.getAdvice() == null && this.getAdviceBeanName() == null) {
            this.setAdvice((Advice)new GuardInterceptor((Guard)this.validator));
        }
    }
}

