/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.validation;

import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.i18n.NLS;
import cn.gtmap.egovplat.core.util.ArrayUtils;

public class ValidationException
extends AppException {
    private static final long serialVersionUID = 1003756154232765865L;
    private String key;
    private String validationMessage;

    public ValidationException(String key, String validationMessage, Throwable cause, Object ... args) {
        super(null, cause, 55, args);
        this.key = key;
        this.validationMessage = validationMessage;
    }

    public ValidationException(String key, String validationMessage, Object ... args) {
        this(key, validationMessage, null, args);
    }

    public ValidationException(String validationMessage, Throwable cause) {
        this("", validationMessage, cause, new Object[0]);
    }

    public String getKey() {
        return this.key;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public String[] getVariables() {
        Object[] args = this.getArgs();
        if (args == null) {
            return new String[0];
        }
        String[] arr = new String[args.length];
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            arr[i] = String.valueOf(args[i]);
        }
        return arr;
    }

    @Override
    public String getMessage() {
        Object[] args = this.getArgs();
        args = args == null ? new Object[]{this.key} : ArrayUtils.add((Object[])args, (int)0, (Object)this.key);
        return this.key + " " + NLS.get(this.validationMessage, args);
    }
}

