/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.ex.AppException;
import cn.gtmap.egovplat.core.ex.SourceExtractor;
import cn.gtmap.egovplat.core.util.ExUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContextUtils;

public class FriendlyExceptionRenderInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(FriendlyExceptionRenderInterceptor.class);
    private String devView = "common/ex";
    private String prodView = "common/error";
    private List<SourceExtractor> sourceExtractors;
    private ViewResolver viewResolver;

    public void setDevView(String devView) {
        this.devView = devView;
    }

    public void setProdView(String prodView) {
        this.prodView = prodView;
    }

    public void setSourceExtractors(List<SourceExtractor> sourceExtractors) {
        this.sourceExtractors = sourceExtractors;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null && !response.isCommitted()) {
            if (response instanceof ServletResponseWrapper) {
                response = (HttpServletResponse)((ServletResponseWrapper)response).getResponse();
            }
            response.resetBuffer();
            HashMap model = Maps.newHashMap();
            AppException appEx = ExUtils.wrap(ex);
            model.put("type", ex.getClass());
            model.put("rawEx", ex);
            model.put("ex", appEx);
            if (Env.isDev()) {
                model.put("source", ExUtils.extractSource(this.sourceExtractors, ex));
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Handler execution exception [" + handler + "],id=" + appEx.getId(), (Throwable)appEx);
            }
            this.viewResolver.resolveViewName(Env.isDev() ? this.devView : this.prodView, RequestContextUtils.getLocale((HttpServletRequest)request)).render((Map)model, request, response);
        }
    }
}

