/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.spring;

import cn.gtmap.egovplat.core.data.P;
import cn.gtmap.egovplat.core.data.PageDefault;
import cn.gtmap.egovplat.core.data.Pageable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DataPageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer index;
        Integer offset;
        Integer size;
        PageDefault def = (PageDefault)parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            size = this.getParam(webRequest, "size", def.prefix(), def.value());
            offset = this.getParam(webRequest, "offset", def.prefix(), def.offset());
            index = this.getParam(webRequest, "index", def.prefix(), def.index());
        } else {
            size = this.getParam(webRequest, "size", null, null);
            offset = this.getParam(webRequest, "offset", null, null);
            index = this.getParam(webRequest, "index", null, null);
        }
        if (size == null && offset == null && index == null) {
            return P.DEFAULT;
        }
        if (size == null) {
            size = 20;
        }
        if (index != null) {
            return P.index(index == 0 ? 1 : index, size);
        }
        if (offset == null) {
            offset = 0;
        }
        return P.offset((int)offset, size);
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty((CharSequence)prefix) ? name : prefix + "_" + name);
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{s}) ? Integer.valueOf(s) : def;
    }
}

