/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.sitemesh;

import cn.gtmap.egovplat.core.util.RequestUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.sitemesh.config.ConfigurableSiteMeshFilter;
import org.springframework.util.StringUtils;

public class SiteMeshFilter
extends ConfigurableSiteMeshFilter {
    public static final String ALONE = "alone";
    private String excludeParam = "alone";
    private String[] excludes;
    private String[] includes;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.excludeParam = filterConfig.getInitParameter("excludeParam");
        if (this.excludeParam == null) {
            this.excludeParam = ALONE;
        }
        this.excludes = StringUtils.delimitedListToStringArray((String)filterConfig.getInitParameter("excludes"), (String)",", (String)" \n\r\t");
        this.includes = StringUtils.delimitedListToStringArray((String)filterConfig.getInitParameter("includes"), (String)",", (String)" \n\r\t");
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hsr = (HttpServletRequest)request;
        if (request.getParameter(this.excludeParam) == null && !RequestUtils.matchAny(hsr, RequestUtils.URL_PATH_HELPER, RequestUtils.PATH_MATCHER, this.excludes) && (this.includes.length == 0 || RequestUtils.matchAny(hsr, RequestUtils.URL_PATH_HELPER, RequestUtils.PATH_MATCHER, this.includes))) {
            super.doFilter(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }
}

