/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.jpa;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;

public class EntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    private DatabasePopulator databasePopulator;
    public static final Set<String> AUTOS = Sets.newHashSet((Object[])new String[]{"update", "create", "create-drop"});

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
        String hbm2ddlAuto = (String)this.getJpaPropertyMap().get("hibernate.hbm2ddl.auto");
        if (hbm2ddlAuto != null && AUTOS.contains(hbm2ddlAuto) && this.databasePopulator != null) {
            EntityManagerFactoryBean.execute(this.databasePopulator, this.getDataSource());
        }
        super.postProcessEntityManagerFactory(emf, pui);
    }

    public static void execute(DatabasePopulator populator, DataSource dataSource) {
        Assert.notNull((Object)populator, (String)"DatabasePopulator must be provided");
        Assert.notNull((Object)dataSource, (String)"DataSource must be provided");
        try {
            Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
            try {
                populator.populate(connection);
            }
            finally {
                if (connection != null) {
                    connection.commit();
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
                }
            }
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Failed to execute database script", (Throwable)ex);
        }
    }
}

