/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.support.hibernate.OneToManyCacheCleaner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;

public class SessionFactoryBean
extends LocalSessionFactoryBean {
    private static final Logger LOG = LoggerFactory.getLogger(SessionFactoryBean.class);
    private static final Set<String> AUTOS = Sets.newHashSet((Object[])new String[]{"update", "create", "create-drop"});
    private DatabasePopulator databasePopulator;
    private Map<String, Object> eventListeners;
    private boolean cleaneOneToManyCache = true;

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    public void setEventListeners(Map<String, Object> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void setCleaneOneToManyCache(boolean cleaneOneToManyCache) {
        this.cleaneOneToManyCache = cleaneOneToManyCache;
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        SessionFactory sessionFactory = super.buildSessionFactory(sfb);
        this.populateDatabase();
        this.registerEventListeners(sessionFactory);
        return sessionFactory;
    }

    private void registerEventListeners(SessionFactory sessionFactory) {
        if (this.eventListeners != null) {
            EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
            for (Map.Entry<String, Object> entry : this.eventListeners.entrySet()) {
                Object listener = entry.getValue();
                try {
                    EventType eventType = EventType.resolveEventTypeByName((String)entry.getKey());
                    EventListenerGroup group = registry.getEventListenerGroup(eventType);
                    if (listener instanceof Collection) {
                        for (Object listener1 : (Collection)listener) {
                            group.appendListener(listener1);
                        }
                        continue;
                    }
                    group.appendListener(listener);
                }
                catch (Exception e) {
                    LOG.error("Unable to register EventListener type:" + entry.getKey(), (Throwable)e);
                }
            }
        }
        if (this.cleaneOneToManyCache) {
            OneToManyCacheCleaner cleaner = new OneToManyCacheCleaner();
            cleaner.setSessionFactory(sessionFactory);
            cleaner.afterPropertiesSet();
        }
    }

    private void populateDatabase() {
        Properties properties = this.getConfiguration().getProperties();
        String hbm2ddlAuto = properties.getProperty("hibernate.hbm2ddl.auto");
        if (this.databasePopulator != null && hbm2ddlAuto != null && AUTOS.contains(hbm2ddlAuto)) {
            DatabasePopulatorUtils.execute((DatabasePopulator)this.databasePopulator, (DataSource)((DataSource)properties.get("hibernate.connection.datasource")));
        }
    }
}

