/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.entity.Repo;
import cn.gtmap.egovplat.core.support.hibernate.HibernateRepo;
import java.io.Serializable;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class RepoFactoryBean<E, ID extends Serializable>
implements FactoryBean<Repo<E, ID>>,
InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private SessionFactory sessionFactory;
    private Class<E> entityClass;
    private Repo<E, ID> repo;

    @Autowired(required=false)
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Autowired(required=false)
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public Repo<E, ID> getObject() throws Exception {
        return this.repo;
    }

    public Class<?> getObjectType() {
        return Repo.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.entityClass, (String)"entityClass is required,it must not be null");
        Assert.isTrue((this.entityManagerFactory != null || this.sessionFactory != null ? 1 : 0) != 0, (String)"entityManagerFactory or sessionFactory is required,it must not be null");
        HibernateRepo<E, ID> repo = this.createRepo(this.entityClass);
        if (this.entityManagerFactory != null) {
            repo.setEntityManagerFactory(this.entityManagerFactory);
        } else if (this.sessionFactory != null) {
            repo.setSessionFactory(this.sessionFactory);
        }
        this.repo = repo;
    }

    protected HibernateRepo<E, ID> createRepo(Class<E> entityClass) {
        return new HibernateRepo(entityClass);
    }
}

