/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.data.P;
import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageImpl;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.data.dsl.Builder;
import cn.gtmap.egovplat.core.data.dsl.DSL;
import cn.gtmap.egovplat.core.data.dsl.QueryParam;
import cn.gtmap.egovplat.core.entity.Repo;
import cn.gtmap.egovplat.core.ex.EntityException;
import cn.gtmap.egovplat.core.ex.EntityNotFoundException;
import cn.gtmap.egovplat.core.support.hibernate.Hibernates;
import cn.gtmap.egovplat.core.support.jpa.JPAHelper;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import cn.gtmap.egovplat.core.util.ClassUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.hibernate.HibernateDeleteClause;
import com.mysema.query.jpa.hibernate.HibernateQuery;
import com.mysema.query.jpa.hibernate.HibernateUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.util.Assert;

public class HibernateRepo<E, ID extends Serializable>
implements Repo<E, ID> {
    private EntityManagerFactory entityManagerFactory;
    private SessionFactory sessionFactory;
    private final Class<E> entityClass;
    private ClassMetadata classMetadata;
    private EntityPath<E> path;
    private PathBuilder<E> pathBuilder;
    private static final Pattern QL_PATTERN = Pattern.compile("select (.+) (from.+?)", 34);
    private static final Pattern ORDERBY_PATTERN = Pattern.compile("order by.+", 34);

    public HibernateRepo(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public HibernateRepo() {
        this.entityClass = ClassUtils.getGenericParameter0(this.getClass());
        if (!AopUtils.isAopProxy((Object)this) && this.entityClass == null) {
            throw new IllegalArgumentException("Entity class not found");
        }
    }

    @Autowired(required=false)
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Autowired(required=false)
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    protected SessionFactory getSessionFactory() {
        return this.entityManagerFactory != null ? JPAHelper.getSessionFactory(this.entityManagerFactory) : this.sessionFactory;
    }

    protected Session getSession() {
        return this.entityManagerFactory != null ? JPAHelper.getSession(this.entityManagerFactory) : this.sessionFactory.getCurrentSession();
    }

    @Override
    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public E getRaw(ID id) {
        return (E)this.getSession().get(this.entityClass, id);
    }

    @Override
    public E get(ID id) {
        return this.prepare(this.getRaw(id));
    }

    @Override
    public E load(ID id) throws EntityNotFoundException {
        return this.assertNotNull(this.get(id), id);
    }

    @Override
    public boolean exists(ID id) {
        return this.get(id) != null;
    }

    @Override
    public List<E> list(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        return this.list(this.criteria(Restrictions.in((String)this.getClassMetadata().getIdentifierPropertyName(), (Collection)((Collection)ids))));
    }

    @Override
    public Map<ID, E> mget(Iterable<ID> ids) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Serializable id : ids) {
            E entity = this.get(id);
            if (entity == null) continue;
            map.put(id, entity);
        }
        return map;
    }

    @Override
    public E getByNaturalId(String fieldName, Object fieldValue) {
        return this.getByNaturalId(Collections.singletonMap(fieldName, fieldValue));
    }

    @Override
    public E getByNaturalId(Map<String, Object> naturalIds) {
        NaturalIdLoadAccess nia = this.getSession().byNaturalId(this.entityClass);
        for (Map.Entry<String, Object> entry : naturalIds.entrySet()) {
            nia.using(entry.getKey(), entry.getValue());
        }
        return (E)this.prepare(nia.load());
    }

    @Override
    public E loadByNaturalId(String fieldName, Object fieldValue) throws EntityNotFoundException {
        return this.loadByNaturalId(Collections.singletonMap(fieldName, fieldValue));
    }

    @Override
    public E loadByNaturalId(Map<String, Object> naturalIds) throws EntityNotFoundException {
        return this.assertNotNull(this.getByNaturalId(naturalIds), naturalIds);
    }

    @Override
    public boolean exists(Map<String, Object> naturalIds) {
        return this.getByNaturalId(naturalIds) != null;
    }

    @Override
    public Criteria criteria(Criterion ... criterions) {
        return this.criteria(ArrayUtils.asList(criterions));
    }

    @Override
    public Criteria criteria(Collection<Criterion> criterions) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        if (criterions != null) {
            for (Criterion c : criterions) {
                if (c == null) continue;
                criteria.add(c);
            }
        }
        return criteria;
    }

    @Override
    public E get(Criteria criteria) {
        return (E)this.prepare(criteria.uniqueResult());
    }

    @Override
    public E load(Criteria criteria) throws EntityNotFoundException {
        return this.assertNotNull(this.get(criteria), criteria);
    }

    @Override
    public boolean exists(Criteria criteria) {
        return this.get(criteria) != null;
    }

    @Override
    public long count(Criteria criteria) {
        return Hibernates.getLong(criteria.setFirstResult(0).setProjection(Projections.rowCount()).uniqueResult());
    }

    @Override
    public List<E> list(Criteria criteria) {
        return this.prepare(criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list());
    }

    @Override
    public Page<E> find(Criteria criteria, Pageable request) {
        int size;
        if (request == null) {
            request = P.first();
        }
        if ((size = request.getSize()) == Integer.MAX_VALUE) {
            this.appendOrder(criteria, request);
            return new PageImpl<E>(this.list(criteria));
        }
        if (size == 0) {
            return new PageImpl(null, this.count(criteria), request);
        }
        if (size < 0) {
            criteria.setFirstResult(request.getOffset()).setMaxResults(-size);
            this.appendOrder(criteria, request);
            return new PageImpl<E>(this.list(criteria));
        }
        criteria.setFirstResult(request.getOffset()).setMaxResults(size);
        this.appendOrder(criteria, request);
        List<E> items = this.list(criteria);
        return new PageImpl<E>(items, items.size() == size ? this.count(criteria) : (long)(request.getOffset() + items.size()), request);
    }

    private void appendOrder(Criteria criteria, Pageable request) {
        if (request != null) {
            for (cn.gtmap.egovplat.core.data.Order order : request.getOrders()) {
                if (order == null) continue;
                criteria.addOrder(order.isAsc() ? org.hibernate.criterion.Order.asc((String)order.getField()) : org.hibernate.criterion.Order.desc((String)order.getField()));
            }
        }
    }

    @Override
    public Query hql(String hql, Object ... args) {
        Query query = this.getSession().createQuery(hql);
        return HibernateRepo.addParameters(query, args);
    }

    @Override
    public Query hql(String hql, Map<String, Object> args) {
        Query query = this.getSession().createQuery(hql);
        return HibernateRepo.addParameters(query, args);
    }

    @Override
    public SQLQuery entitySql(String sql, Object ... args) {
        return this.sql(sql, args).addEntity(this.entityClass);
    }

    @Override
    public SQLQuery entitySql(String sql, Map<String, Object> args) {
        return this.sql(sql, args).addEntity(this.entityClass);
    }

    @Override
    public SQLQuery sql(String sql, Object ... args) {
        return HibernateRepo.addParameters(this.getSession().createSQLQuery(sql), args);
    }

    @Override
    public SQLQuery sql(String sql, Map<String, Object> args) {
        return HibernateRepo.addParameters(this.getSession().createSQLQuery(sql), args);
    }

    @Override
    public E get(Query query) {
        return (E)this.prepare(query.uniqueResult());
    }

    @Override
    public E load(Query query) throws EntityNotFoundException {
        return this.assertNotNull(this.get(query), query);
    }

    @Override
    public boolean exists(Query query) {
        return this.get(query) != null;
    }

    @Override
    public long count(Query query) {
        return Hibernates.getLong(query.list().size());
    }

    @Override
    public List<E> list(Query query) {
        return this.prepare(query.list());
    }

    @Override
    public <F, T> List<T> list(Query query, Function<F, T> function) {
        List ret = query.list();
        ArrayList list = Lists.newArrayListWithCapacity((int)ret.size());
        for (Object f : ret) {
            list.add(function.apply(f));
        }
        return list;
    }

    @Override
    public Page<E> findByHql(String hql, Pageable request, Object ... args) {
        Session session = this.getSession();
        Query query = session.createQuery(hql);
        Query countQuery = session.createQuery(HibernateRepo.toCountQueryString(hql));
        HibernateRepo.addParameters(query, args);
        HibernateRepo.addParameters(countQuery, args);
        return this.find(query, countQuery, request);
    }

    @Override
    public Page<E> findByHql(String hql, Map<String, Object> args, Pageable request) {
        Session session = this.getSession();
        Query query = session.createQuery(hql);
        Query countQuery = session.createQuery(HibernateRepo.toCountQueryString(hql));
        HibernateRepo.addParameters(query, args);
        HibernateRepo.addParameters(countQuery, args);
        return this.find(query, countQuery, request);
    }

    @Override
    public Page<E> findBySql(String sql, Pageable request, Object ... args) {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(sql).addEntity(this.entityClass);
        SQLQuery countQuery = session.createSQLQuery(HibernateRepo.toCountQueryString(sql));
        HibernateRepo.addParameters(query, args);
        HibernateRepo.addParameters(countQuery, args);
        return this.find((Query)query, (Query)countQuery, request);
    }

    @Override
    public Page<E> findBySql(String sql, Map<String, Object> args, Pageable request) {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(sql).addEntity(this.entityClass);
        SQLQuery countQuery = session.createSQLQuery(HibernateRepo.toCountQueryString(sql));
        HibernateRepo.addParameters(query, args);
        HibernateRepo.addParameters(countQuery, args);
        return this.find((Query)query, (Query)countQuery, request);
    }

    public Page<E> findBySql(String sql, Pageable request) {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(sql).addEntity(this.entityClass);
        SQLQuery countQuery = session.createSQLQuery(HibernateRepo.toCountQuerySqlString(sql));
        return this.find((Query)query, (Query)countQuery, request);
    }

    public Page<E> findBySql(String sql, Pageable request, Class aClass) {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(sql).addEntity(aClass);
        SQLQuery countQuery = session.createSQLQuery(HibernateRepo.toCountQuerySqlString(sql));
        return this.find((Query)query, (Query)countQuery, request);
    }

    @Override
    public <F, T> Page<T> findByHql(String hql, Map<String, Object> args, Pageable request, Function<F, T> function) {
        Page<E> page = this.findByHql(hql, args, request);
        List<Object> list = page.getItems();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            list.set(i, function.apply(list.get(i)));
        }
        return page;
    }

    @Override
    public <F, T> Page<T> findBySql(String sql, Map<String, Object> args, Pageable request, Function<F, T> function) {
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery(sql);
        SQLQuery countQuery = session.createSQLQuery(HibernateRepo.toCountQueryString(sql));
        HibernateRepo.addParameters(query, args);
        HibernateRepo.addParameters(countQuery, args);
        Page<E> page = this.find((Query)query, (Query)countQuery, request);
        List<Object> list = page.getItems();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            list.set(i, function.apply(list.get(i)));
        }
        return page;
    }

    private static String toCountQueryString(String qs) {
        char firstChar = qs.charAt(0);
        if (firstChar == 'f' || firstChar == 'F') {
            qs = "select count(*) " + qs;
        } else {
            Matcher matcher = QL_PATTERN.matcher(qs);
            Assert.isTrue((boolean)matcher.matches());
            String fields = matcher.group(1);
            String from = matcher.group(2);
            qs = (fields.toLowerCase().contains("distinct") ? "select count(" + fields + ") " : "select count(*) ") + from;
        }
        return ORDERBY_PATTERN.matcher(qs).replaceAll("");
    }

    private static String toCountQuerySqlString(String qs) {
        Matcher matcher = QL_PATTERN.matcher(qs);
        Assert.isTrue((boolean)matcher.matches());
        qs = "select count(*) from(" + qs + ")";
        return qs;
    }

    @Override
    public Page<E> find(Query query, Query countQuery, Pageable request) {
        int size;
        if (request == null) {
            request = P.first();
        }
        if ((size = request.getSize()) == Integer.MAX_VALUE) {
            return new PageImpl<E>(this.list(query));
        }
        if (size == 0) {
            return new PageImpl(null, Hibernates.getInt(countQuery.uniqueResult()), request);
        }
        if (size < 0) {
            query.setFirstResult(request.getOffset()).setMaxResults(-size);
            return new PageImpl<E>(this.list(query));
        }
        query.setFirstResult(request.getOffset()).setMaxResults(size);
        List<E> items = this.list(query);
        return new PageImpl<E>(items, items.size() == size ? (long)Hibernates.getInt(countQuery.uniqueResult()) : (long)(request.getOffset() + items.size()), request);
    }

    @Override
    public Builder q() {
        return DSL.q();
    }

    @Override
    public Builder i() {
        return this.q().insert();
    }

    @Override
    public Builder u() {
        return this.q().update();
    }

    @Override
    public Builder d() {
        return this.q().delete();
    }

    @Override
    public E get(Builder dsl) {
        QueryParam param = dsl.from(this.entityClass).build();
        Object query = dsl.isSql() ? this.sql(param.getQuery(), param.getArgs()) : this.hql(param.getQuery(), param.getArgs());
        return this.get((Query)query);
    }

    @Override
    public E load(Builder dsl) throws EntityNotFoundException {
        QueryParam param = dsl.from(this.entityClass).build();
        Object query = dsl.isSql() ? this.sql(param.getQuery(), param.getArgs()) : this.hql(param.getQuery(), param.getArgs());
        return this.assertNotNull(this.get((Query)query), param.getQuery());
    }

    @Override
    public boolean exists(Builder dsl) {
        return this.get(dsl) != null;
    }

    @Override
    public long count(Builder dsl) {
        QueryParam param = dsl.from(this.entityClass).build();
        Object query = dsl.isSql() ? this.sql(param.getCountQuery(), param.getArgs()) : this.hql(param.getCountQuery(), param.getArgs());
        return this.count((Query)query);
    }

    @Override
    public List<E> list(Builder dsl) {
        QueryParam param = dsl.from(this.entityClass).build();
        Object query = dsl.isSql() ? this.sql(param.getQuery(), param.getArgs()) : this.hql(param.getQuery(), param.getArgs());
        return this.list((Query)query);
    }

    @Override
    public Page<E> find(Builder dsl) {
        SQLQuery countQuery;
        SQLQuery query;
        QueryParam param = dsl.from(this.entityClass).build();
        if (dsl.isSql()) {
            query = this.entitySql(param.getQuery(), param.getArgs());
            countQuery = this.sql(param.getCountQuery(), param.getArgs());
        } else {
            query = this.hql(param.getQuery(), param.getArgs());
            countQuery = this.hql(param.getCountQuery(), param.getArgs());
        }
        return this.find((Query)query, (Query)countQuery, P.offset(param.getOffset(), param.getSize()));
    }

    @Override
    public int execute(Builder dsl) {
        QueryParam param = dsl.from(this.entityClass).build();
        Object query = dsl.isSql() ? this.sql(param.getQuery(), param.getArgs()) : this.hql(param.getQuery(), param.getArgs());
        return query.executeUpdate();
    }

    @Override
    public HibernateQuery dslQuery(Predicate ... predicates) {
        HibernateQuery query = (HibernateQuery)new HibernateQuery(this.getSession()).from(this.getPath());
        return ArrayUtils.isEmpty((Object[])predicates) ? query : (HibernateQuery)query.where(predicates);
    }

    @Override
    public HibernateQuery dslQuery(Collection<Predicate> predicates) {
        return predicates == null ? this.dslQuery(new Predicate[0]) : this.dslQuery(predicates.toArray(new Predicate[predicates.size()]));
    }

    @Override
    public UpdateClause<? extends UpdateClause> dslUpdate(Predicate ... predicates) {
        HibernateUpdateClause updateClause = new HibernateUpdateClause(this.getSession(), this.getPath());
        updateClause.where(predicates);
        return updateClause;
    }

    @Override
    public UpdateClause<? extends UpdateClause> dslUpdate(List<Predicate> predicates) {
        return this.dslUpdate(predicates.toArray(new Predicate[predicates.size()]));
    }

    @Override
    public DeleteClause<? extends DeleteClause> dslDelete(Predicate ... predicates) {
        HibernateDeleteClause deleteClause = new HibernateDeleteClause(this.getSession(), this.getPath());
        deleteClause.where(predicates);
        return deleteClause;
    }

    @Override
    public DeleteClause<? extends DeleteClause> dslDelete(Collection<Predicate> predicates) {
        return this.dslDelete(predicates.toArray(new Predicate[predicates.size()]));
    }

    public EntityPath<E> getPath() {
        if (this.path == null) {
            this.path = SimpleEntityPathResolver.INSTANCE.createPath(this.entityClass);
        }
        return this.path;
    }

    @Override
    public E get(Predicate ... predicates) {
        return (E)this.prepare(this.dslQuery(predicates).uniqueResult(this.getPath()));
    }

    @Override
    public E load(Predicate ... predicates) throws EntityNotFoundException {
        return this.assertNotNull(this.get(predicates), "");
    }

    @Override
    public boolean exists(Predicate ... predicates) {
        return this.get(predicates) != null;
    }

    @Override
    public long count(Predicate ... predicates) {
        return this.dslQuery(predicates).count();
    }

    @Override
    public List<E> list(OrderSpecifier ... orders) {
        return this.list((HibernateQuery)this.dslQuery(new Predicate[0]).orderBy(orders));
    }

    @Override
    public List<E> list(Predicate predicate, OrderSpecifier ... orders) {
        return this.list((HibernateQuery)this.dslQuery(predicate).orderBy(orders));
    }

    @Override
    public List<E> list(Collection<Predicate> predicates, OrderSpecifier ... orders) {
        return this.list((HibernateQuery)this.dslQuery(predicates).orderBy(orders));
    }

    @Override
    public List<E> list(HibernateQuery query) {
        return this.prepare(query.list(this.getPath()));
    }

    @Override
    public Page<E> find(Predicate predicate, Pageable request) {
        return this.find(this.dslQuery(predicate), request);
    }

    @Override
    public Page<E> find(Collection<Predicate> predicates, Pageable request) {
        return this.find(this.dslQuery(predicates), request);
    }

    @Override
    public Page<E> find(Pageable request, Predicate ... predicates) {
        return this.find(ArrayUtils.asList(predicates), request);
    }

    @Override
    public Page<E> find(HibernateQuery query, Pageable request) {
        List<E> items;
        int size;
        if (request == null) {
            request = P.first();
        }
        if ((size = request.getSize()) == Integer.MAX_VALUE) {
            for (cn.gtmap.egovplat.core.data.Order order : request.getOrders()) {
                query.orderBy(this.toDslOrder(order));
            }
            return new PageImpl<E>(this.list(query));
        }
        if (size == 0) {
            return new PageImpl(null, query.count(), request);
        }
        if (size < 0) {
            ((HibernateQuery)query.offset((long)request.getOffset())).limit((long)(-size));
            return new PageImpl<E>(this.list(query));
        }
        ((HibernateQuery)query.offset((long)request.getOffset())).limit((long)size);
        for (cn.gtmap.egovplat.core.data.Order order : request.getOrders()) {
            query.orderBy(this.toDslOrder(order));
        }
        return new PageImpl<E>(items, (items = this.list(query)).size() == size ? (long)Hibernates.getInt(query.count()) : (long)(request.getOffset() + items.size()), request);
    }

    @Override
    public long count() {
        return this.count(this.criteria(new Criterion[0]));
    }

    @Override
    public List<E> list() {
        return this.list(this.criteria(new Criterion[0]));
    }

    @Override
    public Page<E> find(Pageable request) {
        return this.find(this.criteria(new Criterion[0]), request);
    }

    @Override
    public int execute(Query query) {
        return query.executeUpdate();
    }

    @Override
    public <S extends E> S save(S entity) throws EntityException {
        this.beforeSave(entity);
        try {
            this.getSession().persist(entity);
        }
        catch (Exception e) {
            throw new EntityException(this.entityClass, (Throwable)e);
        }
        this.afterSave(entity);
        return this.prepare(entity);
    }

    @Override
    public <S extends E> S saveOrUpdate(S entity) throws EntityException {
        this.beforeSave(entity);
        try {
            this.getSession().saveOrUpdate(entity);
        }
        catch (Exception e) {
            throw new EntityException(this.entityClass, (Throwable)e);
        }
        this.afterSave(entity);
        return this.prepare(entity);
    }

    @Override
    public <S extends E> List<S> save(Iterable<S> entities) throws EntityException {
        ArrayList result = Lists.newArrayList();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    public <S extends E> S merge(S entity) throws EntityException {
        this.beforeSave(entity);
        try {
            entity = this.getSession().merge(entity);
        }
        catch (Exception e) {
            throw new EntityException(this.entityClass, (Throwable)e);
        }
        this.afterSave(entity);
        return this.prepare(entity);
    }

    @Override
    public <S extends E> S saveAndFlush(S entity) throws EntityException {
        S result = this.save(entity);
        this.getSession().flush();
        return result;
    }

    @Override
    public void delete(E entity) {
        this.getSession().delete(this.beforeDelete(entity));
        this.afterDelete(entity);
    }

    @Override
    public void delete(Iterable<? extends E> entities) {
        for (E entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public void deleteById(ID id) throws EntityNotFoundException {
        this.delete(this.load(id));
    }

    @Override
    public void deleteByIds(Iterable<ID> ids) {
        for (Serializable id : ids) {
            E entity = this.get(id);
            if (entity == null) continue;
            this.delete(entity);
        }
    }

    @Override
    public void deleteByIds(ID ... ids) {
        this.deleteByIds((Iterable<ID>)ArrayUtils.asList(ids));
    }

    @Override
    public void deleteAll() {
        this.execute(this.hql("delete from " + this.getEntityName(), new Object[0]));
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return this.entityClass.isAssignableFrom(clazz);
    }

    @Override
    public <S extends E> S prepare(S entity) {
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            E be = entities.get(i);
            E ae = this.prepare(be);
            if (ae == be) continue;
            entities.set(i, ae);
        }
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        Assert.notNull(entity, (String)"Entity is required");
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        Assert.notNull(entity, (String)"Entity is required");
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        return entity;
    }

    protected final ClassMetadata getClassMetadata() {
        if (this.classMetadata == null) {
            this.classMetadata = this.getSessionFactory().getClassMetadata(this.entityClass);
        }
        return this.classMetadata;
    }

    protected final ID getId(E entity) {
        return (ID)this.getClassMetadata().getIdentifier(entity, (SessionImplementor)this.getSession());
    }

    protected final String getEntityName() {
        return this.getClassMetadata().getEntityName();
    }

    protected final String getTableName() {
        return ((AbstractEntityPersister)this.getClassMetadata()).getTableName();
    }

    protected final String getCollectionRole(String collectionName) {
        return this.getClassMetadata().getEntityName() + "." + collectionName;
    }

    private static <Q extends Query> Q addParameters(Q query, Object ... args) {
        if (args != null) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                query.setParameter(i, args[i]);
            }
        }
        return query;
    }

    private static <Q extends Query> Q addParameters(Q query, Map<String, Object> args) {
        if (args != null) {
            String[] paramters = query.getNamedParameters();
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < paramters.length; ++i) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{paramters[i]})) continue;
                paramMap.put(paramters[i], paramters[i]);
            }
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                Object arg = entry.getValue();
                if (!paramMap.containsKey(entry.getKey().toString())) continue;
                if (arg == null) {
                    query.setParameter(entry.getKey(), null);
                    continue;
                }
                if (arg.getClass().isArray()) {
                    query.setParameterList(entry.getKey(), (Object[])entry.getValue());
                    continue;
                }
                if (arg instanceof Collection) {
                    query.setParameterList(entry.getKey(), (Collection)arg);
                    continue;
                }
                query.setParameter(entry.getKey(), arg);
            }
        }
        return query;
    }

    protected E assertNotNull(E entity, Object arg) {
        if (entity == null) {
            throw new EntityNotFoundException(this.entityClass, arg.toString());
        }
        return entity;
    }

    private PathBuilder<E> getBuilder() {
        if (this.pathBuilder == null) {
            this.pathBuilder = new PathBuilder(this.getPath().getType(), this.getPath().getMetadata());
        }
        return this.pathBuilder;
    }

    private OrderSpecifier toDslOrder(cn.gtmap.egovplat.core.data.Order order) {
        PathBuilder property = this.getBuilder().get(order.getField());
        return new OrderSpecifier(order.isAsc() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

