/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.hibernate;

import cn.gtmap.egovplat.core.entity.EntityFilter;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityFilterListener
implements PostLoadEventListener,
SaveOrUpdateEventListener,
PersistEventListener,
MergeEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PreDeleteEventListener,
PostDeleteEventListener,
InitializingBean {
    private static final long serialVersionUID = -6594194452243003163L;
    private EntityFilter<Object> filter;
    private SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setFilter(EntityFilter<Object> filter) {
        this.filter = filter;
    }

    public void onPostLoad(PostLoadEvent event) {
        this.filter.prepare(event.getEntity());
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        this.filter.beforeSave(event.getObject());
    }

    public void onPersist(PersistEvent event) throws HibernateException {
        this.filter.beforeSave(event.getObject());
    }

    public void onPersist(PersistEvent event, Map createdAlready) throws HibernateException {
        this.filter.beforeSave(event.getObject());
    }

    public void onMerge(MergeEvent event) throws HibernateException {
        this.filter.beforeSave(event.getOriginal());
    }

    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        this.filter.beforeSave(event.getOriginal());
    }

    public void onPostInsert(PostInsertEvent event) {
        this.filter.afterSave(event.getEntity());
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.filter.afterSave(event.getEntity());
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        this.filter.beforeDelete(event.getEntity());
        return false;
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.filter.afterDelete(event.getEntity());
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.POST_LOAD).appendListener((Object)this);
        registry.getEventListenerGroup(EventType.SAVE).prependListener((Object)this);
        registry.getEventListenerGroup(EventType.UPDATE).prependListener((Object)this);
        registry.getEventListenerGroup(EventType.SAVE_UPDATE).prependListener((Object)this);
        registry.getEventListenerGroup(EventType.PERSIST).prependListener((Object)this);
        registry.getEventListenerGroup(EventType.MERGE).prependListener((Object)this);
        registry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)this);
        registry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)this);
        registry.getEventListenerGroup(EventType.PRE_DELETE).appendListener((Object)this);
        registry.getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)this);
    }
}

