/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.support.freemarker;

import cn.gtmap.egovplat.core.support.freemarker.FmUtils;
import com.google.common.collect.Maps;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class ConfigurableObjectWrapper
extends DefaultObjectWrapper
implements InitializingBean {
    private Map<Class, Class<TemplateModel>> classMapping = Collections.emptyMap();
    private Map<Class, Constructor> cache = Maps.newHashMap();

    public void setClassMapping(Map<Class, Class<TemplateModel>> classMapping) {
        this.classMapping = classMapping;
    }

    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
        Class<?> clazz = obj.getClass();
        Constructor<?> constructor = null;
        if (this.cache.containsKey(clazz)) {
            constructor = this.cache.get(clazz);
        } else {
            for (Map.Entry<Class, Class<TemplateModel>> entry : this.classMapping.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                constructor = entry.getValue().getConstructors()[0];
                break;
            }
            this.cache.put(clazz, constructor);
        }
        if (constructor != null) {
            try {
                return (TemplateModel)constructor.newInstance(new Object[]{obj, this});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.handleUnknownType(obj);
    }

    public void afterPropertiesSet() throws Exception {
        FmUtils.wrapper = this;
    }
}

