/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.gis;

import cn.gtmap.egovplat.core.bean.Titleable;
import javax.measure.quantity.Length;
import javax.measure.unit.BaseUnit;
import org.apache.commons.lang3.StringUtils;

public enum EsriUnits implements Titleable
{
    esriUnknownUnits("esriUnknownUnits"),
    esriInches("esriInches"),
    esriPoints("esriPoints"),
    esriFeet("esriFeet"),
    esriYards("esriYards"),
    esriMiles("esriMiles"),
    esriNauticalMiles("esriNauticalMiles"),
    esriMillimeters("esriMillimeters"),
    esriCentimeters("esriCentimeters"),
    esriMeters("esriMeters"),
    esriKilometers("esriKilometers"),
    esriDecimalDegrees("esriDecimalDegrees"),
    esriDecimeters("esriDecimeters");

    private String title;

    private EsriUnits(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public static EsriUnits fromBaseUnit(BaseUnit<Length> unit) {
        String symbol = unit.getSymbol();
        if (StringUtils.equals((CharSequence)symbol, (CharSequence)"m")) {
            return esriMeters;
        }
        if (StringUtils.equals((CharSequence)symbol, (CharSequence)"Decimal Degree")) {
            return esriDecimalDegrees;
        }
        return esriMeters;
    }
}

