/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.env.Env;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class EnvConfigPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer
implements Map<String, Object> {
    private MutablePropertySources propertySources;
    private EnvConfigPlaceholderConfigurer parent;

    public void setParent(EnvConfigPlaceholderConfigurer parent) {
        this.parent = parent;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.propertySources = new MutablePropertySources();
        try {
            Properties props = this.mergeProperties();
            if (this.parent != null) {
                this.propertySources.addLast((PropertySource)new PropertySource<Map<String, Object>>("parentProperties", (Map)this.parent){

                    public String getProperty(String name) {
                        return (String)((Map)this.source).get(name);
                    }
                });
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource("localProperties", props);
                if (this.localOverride) {
                    this.propertySources.addFirst((PropertySource)localPropertySource);
                } else {
                    this.propertySources.addLast((PropertySource)localPropertySource);
                }
            } else {
                Env.configuration = Attrs.compositeAttrable(Env.configuration, Attrs.newJSONAttrable(props));
                this.propertySources.addLast((PropertySource)new PropertySource<Attrable>("envProperties", Env.configuration){

                    public String getProperty(String name) {
                        return ((Attrable)this.source).getAttr(name);
                    }
                });
                if (this.localOverride) {
                    this.propertySources.addFirst((PropertySource)new PropertiesPropertySource("localProperties", props));
                }
                this.propertySources.addLast((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", System.getenv()));
            }
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", (Throwable)ex);
        }
        this.setPropertySources((PropertySources)this.propertySources);
        super.postProcessBeanFactory(beanFactory);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        for (PropertySource propertySource : this.propertySources) {
            Object candidate = propertySource.getProperty((String)key);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }
}

