/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.env;

import cn.gtmap.egovplat.core.Constants;
import cn.gtmap.egovplat.core.attr.Attrs;
import cn.gtmap.egovplat.core.env.Env;
import cn.gtmap.egovplat.core.util.IO;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class EnvConfLoader {
    protected final Log logger = LogFactory.getLog(EnvConfLoader.class);
    public static final String HOME_NAME = "egov.home";
    public static final String CONF_NAME = "egov.conf";
    public static final String DATA_NAME = "egov.data";
    public static final String PROPERTY_FILE_NAME = "egov.properties";
    public static final String DEFAULT_ACTIVE_CONF = "default";
    public static final String EGOV_HOME_FOLDER = "egov-home";

    public static void load(String ... paths) {
        EnvConfLoader cl = new EnvConfLoader();
        cl.loadConfig(paths);
    }

    public void loadConfig(String ... paths) {
        File home;
        String configHome = this.getConfigProperty(HOME_NAME);
        if (configHome != null) {
            this.logger.info((Object)("Egov home has been set to [" + configHome + "],skip"));
            return;
        }
        File root = this.determineRootDir(paths);
        this.logger.info((Object)("Use egov-home dir:[" + root + "]"));
        if (root != null) {
            this.logger.info((Object)("Use egov-home dir:[" + root + "]"));
            File activeFile = new File(root, "active.conf");
            String active = DEFAULT_ACTIVE_CONF;
            try {
                active = FileUtils.readFileToString((File)activeFile);
            }
            catch (IOException e) {
                this.logger.info((Object)("Read active profile from [" + activeFile.getAbsolutePath() + "] fail,use default"));
            }
            home = new File(root, active);
            if (!home.exists() && !(home = new File(root, DEFAULT_ACTIVE_CONF)).exists()) {
                this.logger.error((Object)("Egov active conf [" + home.getAbsoluteFile() + "] not exsit"));
            }
            this.logger.info((Object)("Use Custom config home dir:[" + home + "]"));
        } else {
            URL url = this.getClass().getResource("/META-INF/conf/egov.properties");
            if (url != null) {
                try {
                    home = new File(url.toURI()).getParentFile().getParentFile();
                    this.logger.info((Object)("Custom config home not found,Use classpath config home dir [" + home.getAbsolutePath() + "]"));
                }
                catch (URISyntaxException ignored) {
                    return;
                }
            } else {
                this.logger.error((Object)"Load config error,config not found");
                return;
            }
        }
        String homePath = home.getAbsolutePath();
        String confPath = homePath + File.separator + "conf";
        File confFile = new File(confPath, PROPERTY_FILE_NAME);
        Properties props = new Properties();
        this.setConfigProperty(props, HOME_NAME, home);
        this.setConfigProperty(props, CONF_NAME, new File(confPath));
        if (this.getConfigProperty(props, DATA_NAME) == null) {
            this.setConfigProperty(props, DATA_NAME, new File(homePath + File.separator + "data"));
        }
        this.loadProperties(props, confFile);
        Env.configuration = Attrs.compositeAttrable(props, System.getProperties());
        String ps = Env.get("app.profiles");
        if (!confFile.exists()) {
            this.logger.info((Object)("Egov config file [" + confFile.getAbsolutePath() + "] not found,enable install mode"));
            ps = ps == null ? "install" : ps + ",install";
        }
        if (ps == null) {
            ps = DEFAULT_ACTIVE_CONF;
        }
        if (System.getProperty("prod") != null) {
            ps = ps + ",prod";
        }
        Env.setAttr("app.profiles", ps);
        System.setProperty("spring.profiles.active", ps);
        this.logger.info((Object)("Use App profiles [" + ps + "]"));
        Env.profiles = StringUtils.commaDelimitedListToSet((String)ps);
        Env.mode = Env.profiles.contains(Env.Mode.PROD.getTitle()) ? Env.Mode.PROD : (Env.profiles.contains(Env.Mode.TEST.getTitle()) ? Env.Mode.TEST : Env.Mode.DEV);
        this.setConfigProperty(props, "app.model", Env.mode.getTitle());
        this.logger.info((Object)("Use App mode     [" + Env.mode.getTitle() + "]"));
    }

    private void loadProperties(Properties p, File file) {
        try {
            if (!file.exists()) {
                return;
            }
            Properties props = IO.readProperties(file);
            for (String name : props.stringPropertyNames()) {
                this.setConfigPropertyAndSystemProperty(p, name, Constants.PLACEHOLDER_HELPER.replacePlaceholders(props.getProperty(name), props));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("error to load props file:[" + file.getAbsolutePath() + "]"), (Throwable)e);
        }
    }

    protected String getConfigProperty(Properties props, String key) {
        return props.getProperty(key);
    }

    protected void setConfigProperty(Properties props, String key, String value) {
        props.put(key, value);
        this.logger.debug((Object)("Set env property [" + key + "=" + value + "]"));
    }

    protected void setConfigProperty(Properties props, String key, File file) {
        this.setConfigPropertyAndSystemProperty(props, key, file.toURI().toString());
        this.setConfigPropertyAndSystemProperty(props, key + ".path", file.getAbsolutePath());
    }

    protected void setConfigPropertyAndSystemProperty(Properties props, String key, String value) {
        System.setProperty(key, value);
        this.setConfigProperty(props, key, value);
    }

    private File determineRootDir(String ... paths) {
        File root;
        if (paths != null) {
            for (String path : paths) {
                root = new File(path);
                if (!root.exists()) continue;
                return root;
            }
        }
        for (String path : new String[]{System.getProperty("EGOV_HOME"), System.getenv("EGOV_HOME")}) {
            if (path == null || !(root = new File(path)).exists()) continue;
            return root;
        }
        for (String path : new String[]{System.getProperty("catalina.base"), System.getProperty("catalina.home"), System.getProperty("user.home"), "/opt"}) {
            if (path == null || !(root = new File(path, EGOV_HOME_FOLDER)).exists()) continue;
            return root;
        }
        return null;
    }

    protected String getConfigProperty(String key) {
        return System.getProperty(key);
    }
}

