/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.entity;

import java.util.List;

public abstract class EntitySorter<E> {
    public void initWeight(E entity) {
        List<E> siblings = this.getSiblings(entity);
        if (siblings.isEmpty()) {
            this.setWeight(entity, 1);
        } else {
            this.setWeight(entity, this.getWeight(siblings.get(siblings.size() - 1)) + 1);
        }
    }

    public void move(E entity, boolean isUp) {
        List<E> siblings = this.getSiblings(entity);
        for (int i = 0; i < siblings.size(); ++i) {
            E entity1 = siblings.get(i);
            if (!this.equals(entity1, entity)) continue;
            if (isUp) {
                if (i <= 0) break;
                this.swapWeight(entity, siblings.get(i - 1));
                break;
            }
            if (i >= siblings.size() - 1) break;
            this.swapWeight(entity, siblings.get(i + 1));
            break;
        }
    }

    private void swapWeight(E entity, E entity1) {
        int weight = this.getWeight(entity);
        this.setWeight(entity, this.getWeight(entity1));
        this.setWeight(entity1, weight);
        this.save(entity);
        this.save(entity1);
    }

    protected boolean equals(E entity, E entity1) {
        return entity.equals(entity1);
    }

    protected abstract List<E> getSiblings(E var1);

    protected abstract int getWeight(E var1);

    protected abstract void setWeight(E var1, int var2);

    protected abstract void save(E var1);
}

