/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.entity;

import cn.gtmap.egovplat.core.entity.EntityFilter;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class EntityFilterChain<E>
implements EntityFilter<E> {
    private LinkedList<EntityFilter<E>> filters = new LinkedList();

    public EntityFilterChain(Collection<EntityFilter<E>> filters) {
        this.setFilters(filters);
    }

    public EntityFilterChain(EntityFilter<E> ... filters) {
        this(ArrayUtils.asList(filters));
    }

    public EntityFilterChain() {
    }

    public void setFilters(Collection<EntityFilter<E>> filters) {
        this.filters.addAll(filters);
    }

    public void addFirst(EntityFilter<E> entityFilter) {
        this.filters.addFirst(entityFilter);
    }

    public void addLast(EntityFilter<E> entityFilter) {
        this.filters.addLast(entityFilter);
    }

    @Override
    public boolean accept(Class clazz) {
        return true;
    }

    @Override
    public <S extends E> S prepare(S entity) {
        for (EntityFilter entityFilter : this.filters) {
            if (!entityFilter.accept(entity.getClass())) continue;
            entity = entityFilter.prepare(entity);
        }
        return entity;
    }

    @Override
    public List<E> prepare(List<E> entities) {
        for (EntityFilter entityFilter : this.filters) {
            if (entities.size() > 0 && !entityFilter.accept(entities.get(0).getClass())) continue;
            entities = entityFilter.prepare(entities);
        }
        return entities;
    }

    @Override
    public E beforeSave(E entity) {
        for (EntityFilter entityFilter : this.filters) {
            if (!entityFilter.accept(entity.getClass())) continue;
            entity = entityFilter.beforeSave(entity);
        }
        return entity;
    }

    @Override
    public E afterSave(E entity) {
        for (EntityFilter entityFilter : this.filters) {
            if (!entityFilter.accept(entity.getClass())) continue;
            entity = entityFilter.afterSave(entity);
        }
        return entity;
    }

    @Override
    public E beforeDelete(E entity) {
        for (EntityFilter entityFilter : this.filters) {
            if (!entityFilter.accept(entity.getClass())) continue;
            entity = entityFilter.beforeDelete(entity);
        }
        return entity;
    }

    @Override
    public E afterDelete(E entity) {
        for (EntityFilter entityFilter : this.filters) {
            if (!entityFilter.accept(entity.getClass())) continue;
            entity = entityFilter.afterDelete(entity);
        }
        return entity;
    }
}

