/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.encrypt;

import cn.gtmap.egovplat.core.util.Codecs;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class RSAKeyHelper {
    public static void main(String[] args) throws Exception {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = new SecureRandom();
        if (args.length > 1) {
            random.setSeed(args[1].getBytes("utf-8"));
        } else {
            random.setSeed(random.nextLong());
        }
        keygen.initialize(1024, random);
        KeyPair kp = keygen.generateKeyPair();
        PublicKey publicKey = kp.getPublic();
        PrivateKey privateKey = kp.getPrivate();
        System.out.println("------------------------- publicKey ------------------------");
        System.out.println(Codecs.encode(publicKey.getEncoded()));
        System.out.println("------------------------- privateKey ------------------------");
        System.out.println(Codecs.encode(privateKey.getEncoded()));
        System.out.println("-------------------------------------------------------------");
    }
}

