/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.encrypt;

import cn.gtmap.egovplat.core.encrypt.EncryptException;
import cn.gtmap.egovplat.core.encrypt.EncryptService;
import cn.gtmap.egovplat.core.util.Codecs;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractEncryptService
implements EncryptService,
InitializingBean {
    private String key;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private String encryptKey;
    private String decryptKey;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public String getDecryptKey() {
        return this.decryptKey;
    }

    public void setDecryptKey(String decryptKey) {
        this.decryptKey = decryptKey;
    }

    @Override
    public String encrypt(String str) {
        return Codecs.encode(this.encrypt(Codecs.bytes(str)));
    }

    @Override
    public String decrypt(String str) {
        return Codecs.string(this.decrypt(Codecs.decode(str)));
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        if (this.encryptCipher == null) {
            throw new IllegalStateException("EncryptCipher not init");
        }
        try {
            return this.encryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (this.decryptCipher == null) {
            throw new IllegalStateException("DecryptCipher not init");
        }
        try {
            return this.decryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.encryptKey == null) {
            this.encryptKey = this.key;
        }
        if (this.decryptKey == null) {
            this.decryptKey = this.key;
        }
        if (this.encryptKey != null) {
            this.encryptCipher = this.initEncryptCipher(Codecs.decode(this.encryptKey));
        }
        if (this.decryptKey != null) {
            this.decryptCipher = this.initDecryptCipher(Codecs.decode(this.decryptKey));
        }
    }

    protected abstract Cipher initEncryptCipher(byte[] var1) throws GeneralSecurityException;

    protected abstract Cipher initDecryptCipher(byte[] var1) throws GeneralSecurityException;
}

