/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.data.dsl;

import cn.gtmap.egovplat.core.data.dsl.Criterion;
import cn.gtmap.egovplat.core.data.dsl.MatchMode;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

final class CriterionImpl
implements Criterion<Criterion> {
    Type type;
    String name;
    Object value;
    LinkedList<Criterion> children;

    CriterionImpl() {
    }

    CriterionImpl(Type type, String name, Object value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    public Criterion and(Criterion ... criterions) {
        return this.and(ArrayUtils.asList(criterions));
    }

    @Override
    public Criterion and(Collection<Criterion> criterions) {
        return this.withCriterions(Type.AND, criterions);
    }

    @Override
    public Criterion or(Criterion ... criterions) {
        return this.or(ArrayUtils.asList(criterions));
    }

    @Override
    public Criterion or(Collection<Criterion> criterions) {
        return this.withCriterions(Type.OR, criterions);
    }

    @Override
    public Criterion expr(String expr) {
        return StringUtils.isEmpty((CharSequence)expr) ? this : this.with(Type.EXPR, expr.trim(), null);
    }

    @Override
    public Criterion expr(String ... exprs) {
        return this.expr(ArrayUtils.asList(exprs));
    }

    @Override
    public Criterion expr(Collection<String> exprs) {
        if (exprs != null && exprs.size() > 0) {
            for (String expr : exprs) {
                this.expr(expr);
            }
        }
        return this;
    }

    @Override
    public Criterion isNull(String name) {
        return this.with(Type.NULL, name, null);
    }

    @Override
    public Criterion notNull(String name) {
        return this.with(Type.NOT_NULL, name, null);
    }

    @Override
    public Criterion empty(String name) {
        return this.eq(name, "");
    }

    @Override
    public Criterion notEmpty(String name) {
        return this.ne(name, "");
    }

    @Override
    public Criterion eq(String name, Object value) {
        return this.with(Type.EQ, name, value);
    }

    @Override
    public Criterion eqIf(String name, Object value, boolean ... conditions) {
        if (!ArrayUtils.isEmpty((boolean[])conditions)) {
            for (boolean condition : conditions) {
                if (condition) continue;
                return this;
            }
        } else if (value == null) {
            return this;
        }
        return this.eq(name, value);
    }

    @Override
    public Criterion eqIfHasValue(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (value instanceof String ? StringUtils.isBlank((CharSequence)((String)value)) : (value instanceof Number ? ((Number)value).longValue() == 0L : value instanceof Date && ((Date)value).getTime() < 1L)) {
            return this;
        }
        return this.eq(name, value);
    }

    @Override
    public Criterion eqOrNull(String name, Object value) {
        return value == null ? this.isNull(name) : this.eq(name, value);
    }

    @Override
    public Criterion ne(String name, Object value) {
        return this.with(Type.NE, name, value);
    }

    @Override
    public Criterion neIf(String name, Object value) {
        return value == null ? this : this.ne(name, value);
    }

    @Override
    public Criterion neOrNotNull(String name, Object value) {
        return value == null ? this.notNull(name) : this.ne(name, value);
    }

    @Override
    public Criterion like(String name, String value) {
        return this.like(name, value, MatchMode.ANYWHERE);
    }

    @Override
    public Criterion likeIf(String name, String value) {
        return value == null ? this : this.like(name, value);
    }

    @Override
    public Criterion like(String name, String value, MatchMode matchMode) {
        return this.with(Type.LIKE, name, matchMode.toMatchString(value));
    }

    @Override
    public Criterion likeIf(String name, String value, MatchMode matchMode) {
        return value == null ? this : this.like(name, value, matchMode);
    }

    @Override
    public Criterion gt(String name, Object value) {
        return this.with(Type.GT, name, value);
    }

    @Override
    public Criterion gtIf(String name, Object value) {
        return value == null ? this : this.gt(name, value);
    }

    @Override
    public Criterion lt(String name, Object value) {
        return this.with(Type.LT, name, value);
    }

    @Override
    public Criterion ltIf(String name, Object value) {
        return value == null ? this : this.lt(name, value);
    }

    @Override
    public Criterion ge(String name, Object value) {
        return this.with(Type.GE, name, value);
    }

    @Override
    public Criterion geIf(String name, Object value) {
        return value == null ? this : this.ge(name, value);
    }

    @Override
    public Criterion le(String name, Object value) {
        return this.with(Type.LE, name, value);
    }

    @Override
    public Criterion leIf(String name, Object value) {
        return value == null ? this : this.le(name, value);
    }

    @Override
    public Criterion between(String name, Object lo, Object hi) {
        return this.with(Type.BETWEEN, name, new Object[]{lo, hi});
    }

    @Override
    public Criterion between(String name, Range range) {
        if (range != null) {
            if (range.hasLowerBound()) {
                if (range.lowerBoundType() == BoundType.CLOSED) {
                    if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                        this.between(name, range.lowerEndpoint(), range.upperEndpoint());
                        return this;
                    }
                    this.ge(name, range.lowerEndpoint());
                } else {
                    this.gt(name, range.lowerEndpoint());
                }
            }
            if (range.hasUpperBound()) {
                if (range.upperBoundType() == BoundType.CLOSED) {
                    this.le(name, range.upperEndpoint());
                } else {
                    this.lt(name, range.upperEndpoint());
                }
            }
        }
        return this;
    }

    @Override
    public Criterion in(String name, Object value) {
        return this.with(Type.IN, name, value);
    }

    @Override
    public Criterion in(String name, Object ... values) {
        return this.in(name, ArrayUtils.asList(values));
    }

    @Override
    public Criterion in(String name, Collection values) {
        return values != null && !values.isEmpty() ? this.with(Type.IN, name, values) : this;
    }

    @Override
    public Criterion notIn(String name, Object value) {
        return this.with(Type.NOT_IN, name, value);
    }

    @Override
    public Criterion notIn(String name, Object ... values) {
        return this.notIn(name, ArrayUtils.asList(values));
    }

    @Override
    public Criterion notIn(String name, Collection values) {
        return values != null && !values.isEmpty() ? this.with(Type.NOT_IN, name, values) : this;
    }

    @Override
    public Criterion exists(Object value) {
        return this.with(Type.EXISTS, "", value);
    }

    @Override
    public Criterion notExists(Object value) {
        return this.with(Type.NOT_EXISTS, "", value);
    }

    private boolean islogical() {
        return this.type == Type.AND || this.type == Type.OR;
    }

    private Criterion copy() {
        CriterionImpl criterion = new CriterionImpl(this.type, this.name, this.value);
        criterion.children = this.children;
        return criterion;
    }

    Criterion with(Type otherType, String name, Object value) {
        if (this.type == null) {
            this.type = otherType;
            this.name = name;
            this.value = value;
        } else {
            CriterionImpl other = new CriterionImpl(otherType, name, value);
            if (this.islogical()) {
                this.children.add(other);
            } else {
                this.children = CriterionImpl.newLinkedList(this.copy(), other);
                this.type = Type.AND;
            }
        }
        return this;
    }

    Criterion withCriterions(Type otherType, Collection<Criterion> criterions) {
        if (otherType == null) {
            otherType = Type.AND;
        }
        if (this.type == null) {
            this.type = Type.AND;
        }
        if (this.type != otherType && (!this.islogical() || this.children != null && this.children.size() > 1)) {
            this.children = CriterionImpl.newLinkedList(this.copy());
        }
        if (this.children == null) {
            this.children = CriterionImpl.newLinkedList(new Criterion[0]);
        }
        this.children.addAll(criterions);
        this.type = otherType;
        return this;
    }

    private static <E> LinkedList<E> newLinkedList(E ... elements) {
        LinkedList list = new LinkedList();
        if (elements != null) {
            Collections.addAll(list, elements);
        }
        return list;
    }

    static enum Type {
        AND,
        OR,
        EXPR,
        NULL,
        NOT_NULL,
        EQ,
        NE,
        LIKE,
        GT,
        LT,
        GE,
        LE,
        BETWEEN,
        IN,
        NOT_IN,
        EXISTS,
        NOT_EXISTS;

    }
}

