/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.data.dsl;

import cn.gtmap.egovplat.core.data.Order;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.egovplat.core.data.dsl.Builder;
import cn.gtmap.egovplat.core.data.dsl.Criterion;
import cn.gtmap.egovplat.core.data.dsl.CriterionImpl;
import cn.gtmap.egovplat.core.data.dsl.JoinType;
import cn.gtmap.egovplat.core.data.dsl.MatchMode;
import cn.gtmap.egovplat.core.data.dsl.QueryParam;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import cn.gtmap.egovplat.core.util.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.util.CollectionUtils;

final class BuilderImpl
implements Builder {
    private static final String SPACE = " ";
    private static final int SELECT = 0;
    private static final int FROM = 1;
    private static final int JOIN = 2;
    private static final int GROUP = 3;
    private static final int ORDER = 4;
    private static final int FIELD = 5;
    private final List[] parts = new List[6];
    private CriterionImpl where = new CriterionImpl();
    private CriterionImpl having = new CriterionImpl();
    private Operation operation = Operation.SELECT;
    private boolean isSql = false;
    private boolean isWhere = true;
    private boolean distinct = false;
    private int offset;
    private int size;

    BuilderImpl() {
    }

    @Override
    public Builder and(Criterion ... criterions) {
        if (this.isWhere) {
            this.where.and(criterions);
        } else {
            this.having.and(criterions);
        }
        return this;
    }

    @Override
    public Builder and(Collection<Criterion> criterions) {
        if (this.isWhere) {
            this.where.and(criterions);
        } else {
            this.having.and(criterions);
        }
        return this;
    }

    @Override
    public Builder or(Criterion ... criterions) {
        if (this.isWhere) {
            this.where.or(criterions);
        } else {
            this.having.or(criterions);
        }
        return this;
    }

    @Override
    public Builder or(Collection<Criterion> criterions) {
        if (this.isWhere) {
            this.where.or(criterions);
        } else {
            this.having.or(criterions);
        }
        return this;
    }

    @Override
    public Builder expr(String expr) {
        if (this.isWhere) {
            this.where.expr(expr);
        } else {
            this.having.expr(expr);
        }
        return this;
    }

    @Override
    public Builder expr(String ... exprs) {
        if (this.isWhere) {
            this.where.expr(exprs);
        } else {
            this.having.expr(exprs);
        }
        return this;
    }

    @Override
    public Builder expr(Collection<String> exprs) {
        if (this.isWhere) {
            this.where.expr(exprs);
        } else {
            this.having.expr(exprs);
        }
        return this;
    }

    @Override
    public Builder isNull(String name) {
        if (this.isWhere) {
            this.where.isNull(name);
        } else {
            this.having.isNull(name);
        }
        return this;
    }

    @Override
    public Builder notNull(String name) {
        if (this.isWhere) {
            this.where.notNull(name);
        } else {
            this.having.notNull(name);
        }
        return this;
    }

    @Override
    public Builder empty(String name) {
        if (this.isWhere) {
            this.where.empty(name);
        } else {
            this.having.empty(name);
        }
        return this;
    }

    @Override
    public Builder notEmpty(String name) {
        if (this.isWhere) {
            this.where.notEmpty(name);
        } else {
            this.having.notEmpty(name);
        }
        return this;
    }

    @Override
    public Builder eq(String name, Object value) {
        if (this.isWhere) {
            this.where.eq(name, value);
        } else {
            this.having.eq(name, value);
        }
        return this;
    }

    @Override
    public Builder eqIf(String name, Object value, boolean ... conditions) {
        if (this.isWhere) {
            this.where.eqIf(name, value, conditions);
        } else {
            this.having.eqIf(name, value, conditions);
        }
        return this;
    }

    @Override
    public Builder eqIfHasValue(String name, Object value) {
        if (this.isWhere) {
            this.where.eqIfHasValue(name, value);
        } else {
            this.having.eqIfHasValue(name, value);
        }
        return this;
    }

    @Override
    public Builder eqOrNull(String name, Object value) {
        if (this.isWhere) {
            this.where.eqOrNull(name, value);
        } else {
            this.having.eqOrNull(name, value);
        }
        return this;
    }

    @Override
    public Builder ne(String name, Object value) {
        if (this.isWhere) {
            this.where.ne(name, value);
        } else {
            this.having.ne(name, value);
        }
        return this;
    }

    @Override
    public Builder neIf(String name, Object value) {
        if (this.isWhere) {
            this.where.neIf(name, value);
        } else {
            this.having.neIf(name, value);
        }
        return this;
    }

    @Override
    public Builder neOrNotNull(String name, Object value) {
        if (this.isWhere) {
            this.where.neOrNotNull(name, value);
        } else {
            this.having.neOrNotNull(name, value);
        }
        return this;
    }

    @Override
    public Builder like(String name, String value) {
        if (this.isWhere) {
            this.where.like(name, value);
        } else {
            this.having.like(name, value);
        }
        return this;
    }

    @Override
    public Builder likeIf(String name, String value) {
        if (this.isWhere) {
            this.where.likeIf(name, value);
        } else {
            this.having.likeIf(name, value);
        }
        return this;
    }

    @Override
    public Builder like(String name, String value, MatchMode matchMode) {
        if (this.isWhere) {
            this.where.like(name, value, matchMode);
        } else {
            this.having.like(name, value, matchMode);
        }
        return this;
    }

    @Override
    public Builder likeIf(String name, String value, MatchMode matchMode) {
        if (this.isWhere) {
            this.where.likeIf(name, value, matchMode);
        } else {
            this.having.likeIf(name, value, matchMode);
        }
        return this;
    }

    @Override
    public Builder gt(String name, Object value) {
        if (this.isWhere) {
            this.where.gt(name, value);
        } else {
            this.having.gt(name, value);
        }
        return this;
    }

    @Override
    public Builder gtIf(String name, Object value) {
        if (this.isWhere) {
            this.where.gtIf(name, value);
        } else {
            this.having.gtIf(name, value);
        }
        return this;
    }

    @Override
    public Builder lt(String name, Object value) {
        if (this.isWhere) {
            this.where.lt(name, value);
        } else {
            this.having.lt(name, value);
        }
        return this;
    }

    @Override
    public Builder ltIf(String name, Object value) {
        if (this.isWhere) {
            this.where.ltIf(name, value);
        } else {
            this.having.ltIf(name, value);
        }
        return this;
    }

    @Override
    public Builder ge(String name, Object value) {
        if (this.isWhere) {
            this.where.ge(name, value);
        } else {
            this.having.ge(name, value);
        }
        return this;
    }

    @Override
    public Builder geIf(String name, Object value) {
        if (this.isWhere) {
            this.where.geIf(name, value);
        } else {
            this.having.geIf(name, value);
        }
        return this;
    }

    @Override
    public Builder le(String name, Object value) {
        if (this.isWhere) {
            this.where.le(name, value);
        } else {
            this.having.le(name, value);
        }
        return this;
    }

    @Override
    public Builder leIf(String name, Object value) {
        if (this.isWhere) {
            this.where.leIf(name, value);
        } else {
            this.having.leIf(name, value);
        }
        return this;
    }

    @Override
    public Builder between(String name, Object lo, Object hi) {
        if (this.isWhere) {
            this.where.between(name, lo, hi);
        } else {
            this.having.between(name, lo, hi);
        }
        return this;
    }

    @Override
    public Builder between(String name, Range range) {
        if (this.isWhere) {
            this.where.between(name, range);
        } else {
            this.having.between(name, range);
        }
        return this;
    }

    @Override
    public Builder in(String name, Object value) {
        if (this.isWhere) {
            this.where.in(name, value);
        } else {
            this.having.in(name, value);
        }
        return this;
    }

    @Override
    public Builder in(String name, Object ... values) {
        if (this.isWhere) {
            this.where.in(name, values);
        } else {
            this.having.in(name, values);
        }
        return this;
    }

    @Override
    public Builder in(String name, Collection values) {
        if (this.isWhere) {
            this.where.in(name, values);
        } else {
            this.having.in(name, values);
        }
        return this;
    }

    @Override
    public Builder notIn(String name, Object value) {
        if (this.isWhere) {
            this.where.notIn(name, value);
        } else {
            this.having.notIn(name, value);
        }
        return this;
    }

    @Override
    public Builder notIn(String name, Object ... values) {
        if (this.isWhere) {
            this.where.notIn(name, values);
        } else {
            this.having.notIn(name, values);
        }
        return this;
    }

    @Override
    public Builder notIn(String name, Collection values) {
        if (this.isWhere) {
            this.where.notIn(name, values);
        } else {
            this.having.notIn(name, values);
        }
        return this;
    }

    @Override
    public Builder exists(Object value) {
        if (this.isWhere) {
            this.where.exists(value);
        } else {
            this.having.exists(value);
        }
        return this;
    }

    @Override
    public Builder notExists(Object value) {
        if (this.isWhere) {
            this.where.notExists(value);
        } else {
            this.having.notExists(value);
        }
        return this;
    }

    @Override
    public Builder sql() {
        this.isSql = true;
        return this;
    }

    @Override
    public boolean isSql() {
        return this.isSql;
    }

    @Override
    public Builder from(Class type) {
        return this.from(type.getSimpleName());
    }

    @Override
    public Builder from(String type) {
        return this.append(this.part(1), type);
    }

    @Override
    public Builder from(String ... types) {
        return this.from(ArrayUtils.asList(types));
    }

    @Override
    public Builder from(Collection<String> types) {
        return this.append(this.part(1), types);
    }

    @Override
    public Builder from(Class type, String alias) {
        return this.from(type.getSimpleName(), alias);
    }

    @Override
    public Builder from(String type, String alias) {
        return this.append(this.part(1), type + (this.isSql ? SPACE : " as ") + alias);
    }

    @Override
    public Builder from(Builder subQuery) {
        return this.append(this.part(1), subQuery);
    }

    @Override
    public Builder from(Builder subQuery, String alias) {
        return this.append(this.part(1), new Pair<Builder, String>(subQuery, alias));
    }

    @Override
    public Builder insert() {
        this.operation = Operation.INSERT;
        return this.sql();
    }

    @Override
    public Builder insert(String type) {
        return this.insert().from(type);
    }

    @Override
    public Builder update() {
        this.operation = Operation.UPDATE;
        return this;
    }

    @Override
    public Builder update(Class type) {
        return this.update(type.getSimpleName());
    }

    @Override
    public Builder update(String type) {
        return this.update().from(type);
    }

    @Override
    public Builder delete() {
        this.operation = Operation.DELETE;
        return this;
    }

    @Override
    public Builder delete(Class type) {
        return this.delete(type.getSimpleName());
    }

    @Override
    public Builder delete(String type) {
        return this.delete().from(type);
    }

    @Override
    public Builder field(String name, Object value) {
        return this.append(this.part(5), new Pair<String, Object>(name, value));
    }

    @Override
    public Builder fields(Object ... pairs) {
        if (pairs != null) {
            int len = pairs.length;
            for (int i = 0; i < len; i += 2) {
                Object key = pairs[i];
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Key must be string");
                }
                this.field((String)key, pairs[i + 1]);
            }
        }
        return this;
    }

    @Override
    public Builder fields(Map<String, Object> values) {
        return this.append(this.part(5), values.entrySet());
    }

    @Override
    public Builder select(String ... fields) {
        return this.select(ArrayUtils.asList(fields));
    }

    @Override
    public Builder select(Collection<String> fields) {
        return this.append(this.part(0), fields);
    }

    @Override
    public Builder select(Builder subQuery) {
        return this.append(this.part(0), subQuery);
    }

    @Override
    public Builder select(Builder subQuery, String alias) {
        return this.append(this.part(0), new Pair<Builder, String>(subQuery, alias));
    }

    @Override
    public Builder distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public Builder join(String path) {
        return this.join(path, JoinType.INNER);
    }

    @Override
    public Builder join(String path, String alias) {
        return this.join(path, alias, JoinType.INNER);
    }

    @Override
    public Builder fetchJoin(String path) {
        return this.fetchJoin(path, JoinType.INNER);
    }

    @Override
    public Builder fetchJoin(String path, String alias) {
        return this.fetchJoin(path, alias, JoinType.INNER);
    }

    @Override
    public Builder join(String path, JoinType type) {
        return this.append(this.part(2), type.getJoinString() + SPACE + path);
    }

    @Override
    public Builder join(String path, String alias, JoinType type) {
        return this.join(path + (this.isSql ? SPACE : " as ") + alias, type);
    }

    @Override
    public Builder fetchJoin(String path, JoinType type) {
        return this.append(this.part(2), type.getJoinString() + " fetch " + path);
    }

    @Override
    public Builder fetchJoin(String path, String alias, JoinType type) {
        return this.fetchJoin(path + " as " + alias, type);
    }

    @Override
    public Builder on(String onString) {
        return this.append(this.part(2), "on " + onString);
    }

    @Override
    public Builder on(String path1, String field1, String path2, String field2) {
        return this.on(path1 + "." + field1 + "=" + path2 + "." + field2);
    }

    @Override
    public Builder where(Criterion ... criterions) {
        return this.where(ArrayUtils.asList(criterions));
    }

    @Override
    public Builder where(Collection<Criterion> criterions) {
        this.isWhere = true;
        this.where.withCriterions(null, criterions);
        return this;
    }

    @Override
    public Builder group(String ... fields) {
        return this.append(this.part(3), ArrayUtils.asList(fields));
    }

    @Override
    public Builder having(Criterion ... criterions) {
        return this.having(ArrayUtils.asList(criterions));
    }

    @Override
    public Builder having(Collection<Criterion> criterions) {
        this.isWhere = false;
        this.having.withCriterions(null, criterions);
        return this;
    }

    @Override
    public Builder index(int index) {
        if (index > 0) {
            this.offset = (index - 1) * this.size;
        }
        return this;
    }

    @Override
    public Builder offset(int offset) {
        if (offset > -1) {
            this.offset = offset;
        }
        return this;
    }

    @Override
    public Builder size(int size) {
        if (size > 0) {
            this.size = size;
        }
        return this;
    }

    @Override
    public Builder with(Pageable pageable) {
        return this.offset(pageable.getOffset()).size(pageable.getSize()).order(pageable.getOrders());
    }

    @Override
    public Builder desc(String field) {
        return this.order(Order.desc(field));
    }

    @Override
    public Builder asc(String field) {
        return this.order(Order.asc(field));
    }

    @Override
    public Builder order(boolean asc, String ... fields) {
        return this.order(Order.orders(asc, fields));
    }

    @Override
    public Builder order(Order ... orders) {
        return this.order(ArrayUtils.asList(orders));
    }

    @Override
    public Builder order(Collection<Order> orders) {
        if (!CollectionUtils.isEmpty(orders)) {
            for (Order order : orders) {
                this.append(this.part(4), order.toString());
            }
        }
        return this;
    }

    @Override
    public QueryParam build() {
        StringBuilder query = new StringBuilder(256);
        StringBuilder countQuery = null;
        if (this.operation == Operation.SELECT) {
            countQuery = new StringBuilder(256);
        }
        HashMap args = Maps.newHashMap();
        this.build(query, countQuery, args, Maps.newHashMap());
        return new QueryImpl(args, query.toString(), countQuery == null ? null : countQuery.toString());
    }

    private List part(int partId) {
        List part = this.parts[partId];
        if (part != null) {
            return part;
        }
        this.parts[partId] = Lists.newLinkedList();
        return this.parts[partId];
    }

    private Builder append(List list, Object ... parts) {
        return this.append(list, ArrayUtils.asList(parts));
    }

    private Builder append(List list, Collection parts) {
        if (BuilderImpl.isNotEmpty(parts)) {
            list.addAll(parts);
        }
        return this;
    }

    private void build(StringBuilder query, StringBuilder countQuery, Map<String, Object> args, Map<String, AtomicInteger> argsIndex) {
        List joins;
        switch (this.operation) {
            case SELECT: {
                List selects = this.parts[0];
                if (!BuilderImpl.isNotEmpty(selects)) {
                    if (this.isSql) {
                        query.append("select * from");
                    } else {
                        query.append("from");
                    }
                    if (countQuery == null) break;
                    countQuery.append("select count(*) from");
                    break;
                }
                StringBuilder selectSb = new StringBuilder(64);
                this.buildList(selects, selectSb, args, argsIndex, false);
                query.append("select ");
                if (this.distinct) {
                    query.append("distinct ");
                }
                query.append((CharSequence)selectSb).append(" from");
                if (countQuery == null) break;
                countQuery.append("select ");
                countQuery.append("count(").append(this.distinct ? "distinct " : "").append((CharSequence)selectSb).append(") from");
                break;
            }
            case UPDATE: {
                query.append("update");
                break;
            }
            case DELETE: {
                query.append("delete from");
                break;
            }
            case INSERT: {
                query.append("insert into");
            }
        }
        query.append(SPACE);
        StringBuilder fromSb = new StringBuilder(64);
        this.buildList(this.parts[1], fromSb, args, argsIndex, !this.isSql && !CollectionUtils.isEmpty((Collection)this.parts[2]));
        query.append((CharSequence)fromSb);
        if (countQuery != null) {
            countQuery.append(SPACE).append((CharSequence)fromSb);
        }
        switch (this.operation) {
            case UPDATE: {
                int i;
                query.append(" set ");
                List fields = this.parts[5];
                int len = fields.size();
                for (i = 0; i < len; ++i) {
                    Map.Entry pair = (Map.Entry)fields.get(i);
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append((String)pair.getKey()).append("=").append(this.putArg((String)pair.getKey(), pair.getValue(), args, argsIndex));
                }
                break;
            }
            case INSERT: {
                int i;
                query.append(" (");
                List fields = this.parts[5];
                int len = fields.size();
                for (i = 0; i < len; ++i) {
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append((String)((Pair)fields.get(i)).getKey());
                }
                query.append(") values (");
                len = fields.size();
                for (i = 0; i < len; ++i) {
                    Map.Entry pair = (Map.Entry)fields.get(i);
                    if (i > 0) {
                        query.append(",");
                    }
                    query.append(this.putArg((String)pair.getKey(), pair.getValue(), args, argsIndex));
                }
                query.append(")");
            }
        }
        if (this.operation == Operation.SELECT && BuilderImpl.isNotEmpty(joins = this.parts[2])) {
            StringBuilder joinSb = new StringBuilder(64);
            joinSb.append(SPACE);
            BuilderImpl.join(joinSb, joins, SPACE);
            query.append((CharSequence)joinSb);
            if (countQuery != null) {
                countQuery.append((CharSequence)joinSb);
            }
        }
        if (this.where != null && this.where.type != null) {
            switch (this.operation) {
                case SELECT: 
                case UPDATE: 
                case DELETE: {
                    StringBuilder whereSb = new StringBuilder(128);
                    whereSb.append(" where ");
                    this.buildCriterion(this.where, whereSb, args, argsIndex, true);
                    query.append((CharSequence)whereSb);
                    if (countQuery == null) break;
                    countQuery.append((CharSequence)whereSb);
                }
            }
        }
        if (this.operation == Operation.SELECT) {
            List orders;
            List groups = this.parts[3];
            if (BuilderImpl.isNotEmpty(groups)) {
                query.append(" group by ");
                BuilderImpl.join(query, groups, ",");
            }
            if (this.having != null && this.having.type != null) {
                query.append(" having ");
                this.buildCriterion(this.having, query, args, argsIndex, true);
            }
            if (BuilderImpl.isNotEmpty(orders = this.parts[4])) {
                query.append(" order by ");
                BuilderImpl.join(query, orders, ",");
            }
        }
    }

    private static void join(StringBuilder sb, Collection collection, String separator) {
        boolean isFirst = true;
        for (Object obj : collection) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(separator);
            }
            sb.append(obj);
        }
    }

    private static boolean isNotEmpty(Collection collection) {
        return collection != null && collection.size() > 0;
    }

    private void buildCriterion(CriterionImpl criterion, StringBuilder query, Map<String, Object> args, Map<String, AtomicInteger> argsIndex, boolean isTop) {
        if (criterion.type == null) {
            criterion.type = CriterionImpl.Type.AND;
        }
        switch (criterion.type) {
            case AND: 
            case OR: {
                LinkedList<Criterion> children;
                if (!isTop) {
                    query.append("(");
                }
                if ((children = criterion.children).size() == 1) {
                    this.buildCriterion((CriterionImpl)children.iterator().next(), query, args, argsIndex, true);
                } else {
                    int i = 0;
                    for (Criterion child : children) {
                        if (i++ > 0) {
                            query.append(criterion.type == CriterionImpl.Type.AND ? " and " : " or ");
                        }
                        this.buildCriterion((CriterionImpl)child, query, args, argsIndex, false);
                    }
                }
                if (!isTop) {
                    query.append(")");
                }
                return;
            }
        }
        query.append(criterion.name);
        switch (criterion.type) {
            case EXPR: {
                return;
            }
            case NULL: {
                query.append(" is null");
                return;
            }
            case NOT_NULL: {
                query.append(" is not null");
                return;
            }
        }
        switch (criterion.type) {
            case BETWEEN: {
                Object[] objs = (Object[])criterion.value;
                query.append(" between ");
                query.append(this.putArg(criterion.name, objs[0], args, argsIndex));
                query.append(" and ");
                query.append(this.putArg(criterion.name, objs[1], args, argsIndex));
                return;
            }
            case IN: {
                query.append(" in ");
                break;
            }
            case NOT_IN: {
                query.append(" not in ");
                break;
            }
            case EXISTS: {
                query.append("exists ");
                break;
            }
            case NOT_EXISTS: {
                query.append("not exists ");
                break;
            }
        }
        switch (criterion.type) {
            case IN: 
            case NOT_IN: 
            case EXISTS: 
            case NOT_EXISTS: {
                Object value = criterion.value;
                if (value instanceof Builder) {
                    query.append("(");
                    ((BuilderImpl)value).build(query, null, args, argsIndex);
                } else if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    query.append((String)pair.getKey());
                    query.append("(");
                    ((BuilderImpl)pair.getValue()).build(query, null, args, argsIndex);
                    query.append(")");
                } else {
                    query.append("(");
                    if (this.isSql && value instanceof Iterable) {
                        int i = 0;
                        for (Object v : (Iterable)value) {
                            if (i++ > 0) {
                                query.append(",");
                            }
                            query.append(this.putArg(criterion.name, v, args, argsIndex));
                        }
                    } else {
                        query.append(this.putArg(criterion.name, value, args, argsIndex));
                    }
                }
                query.append(")");
                return;
            }
        }
        switch (criterion.type) {
            case EQ: {
                query.append("=");
                break;
            }
            case NE: {
                query.append("<>");
                break;
            }
            case LIKE: {
                query.append(" like ");
                break;
            }
            case GT: {
                query.append(">");
                break;
            }
            case LT: {
                query.append("<");
                break;
            }
            case GE: {
                query.append(">=");
                break;
            }
            case LE: {
                query.append("<=");
                break;
            }
        }
        Object value = criterion.value;
        if (value instanceof Builder) {
            query.append("(");
            ((BuilderImpl)value).build(query, null, args, argsIndex);
            query.append(")");
        } else if (value instanceof Pair) {
            Pair pair = (Pair)value;
            query.append((String)pair.getKey());
            query.append("(");
            ((BuilderImpl)pair.getValue()).build(query, null, args, argsIndex);
            query.append(")");
        } else {
            query.append(this.putArg(criterion.name, value, args, argsIndex));
        }
    }

    private String putArg(String key, Object value, Map<String, Object> args, Map<String, AtomicInteger> argsIndex) {
        String uniqueKey = StringUtils.replace((String)key, (String)".", (String)"_");
        if (args.containsKey(uniqueKey)) {
            AtomicInteger index = argsIndex.get(key);
            if (index == null) {
                index = new AtomicInteger();
                argsIndex.put(key, index);
            }
            uniqueKey = uniqueKey + "_" + index.incrementAndGet();
        }
        args.put(uniqueKey, value);
        return ":" + uniqueKey;
    }

    private void buildList(List list, StringBuilder query, Map<String, Object> args, Map<String, AtomicInteger> argsIndex, boolean needRootAlias) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Object item = list.get(i);
            if (i > 0) {
                query.append(",");
            }
            if (item instanceof Builder) {
                query.append("(");
                ((BuilderImpl)item).build(query, null, args, argsIndex);
                query.append(")");
                continue;
            }
            if (item instanceof Pair) {
                Pair pair = (Pair)item;
                query.append("(");
                ((BuilderImpl)pair.getKey()).build(query, null, args, argsIndex);
                query.append(") ");
                query.append((String)pair.getValue());
                continue;
            }
            if (needRootAlias && i == 0) {
                String s = item.toString();
                if (!s.contains(SPACE)) {
                    query.append(s).append(SPACE).append(StringUtils.uncapitalize((String)s));
                    continue;
                }
                query.append(StringUtils.replace((String)s, (String)"as ", (String)""));
                continue;
            }
            query.append(item);
        }
    }

    class QueryImpl
    implements QueryParam {
        private final Map<String, Object> args;
        private final String query;
        private final String countQuery;

        QueryImpl(Map<String, Object> args, String query, String countQuery) {
            this.args = args;
            this.query = query;
            this.countQuery = countQuery;
        }

        @Override
        public boolean isSql() {
            return BuilderImpl.this.isSql;
        }

        @Override
        public Map<String, Object> getArgs() {
            return this.args;
        }

        @Override
        public String getQuery() {
            return this.query;
        }

        @Override
        public String getCountQuery() {
            return this.countQuery;
        }

        @Override
        public int getOffset() {
            return BuilderImpl.this.offset;
        }

        @Override
        public int getSize() {
            return BuilderImpl.this.size;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    static enum Operation {
        SELECT,
        UPDATE,
        DELETE,
        INSERT;

    }
}

