/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.attr.AbstractAttrable;
import cn.gtmap.egovplat.core.attr.FastjsonConverter;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class JSONAttrable
extends AbstractAttrable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2215595339918305246L;
    private JSONObject json;

    public JSONAttrable(JSONObject json) {
        this.json = json;
    }

    public JSONAttrable(Map<String, Object> map) {
        this.json = new JSONObject(map);
    }

    public JSONAttrable(Properties properties) {
        this.json = new JSONObject((Map)properties);
    }

    public JSONAttrable() {
        this.json = new JSONObject();
    }

    public JSONObject getJson() {
        return this.json;
    }

    public void setJson(JSONObject json) {
        this.json = json;
    }

    @Override
    @JSONField(serialize=false)
    public boolean isAttrsEmpty() {
        return this.json.isEmpty();
    }

    @Override
    public boolean hasAttr(String key) {
        return this.json.containsKey((Object)key);
    }

    @Override
    public String getAttr(String key) {
        return this.json.getString(key);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        return JSONAttrable.convert(this.json.get((Object)key), targetType);
    }

    @Override
    @JSONField(serialize=false)
    public Collection<String> getAttrKeys() {
        return this.json.keySet();
    }

    @Override
    public void setAttr(String key, Object value) {
        this.json.put(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        this.json.putAll(map);
    }

    @Override
    public void removeAttr(String key) {
        this.json.remove((Object)key);
    }

    @Override
    public void clearAttrs() {
        this.json.clear();
    }

    public JSONAttrable clone() {
        JSONAttrable obj = null;
        try {
            obj = (JSONAttrable)super.clone();
            obj.setJson((JSONObject)this.json.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public int hashCode() {
        return this.json.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JSONAttrable && ((JSONAttrable)obj).getJson().equals((Object)this.json);
    }

    @Override
    public String toString() {
        return this.json.toJSONString();
    }

    public static <T> T convert(Object value, Class<T> targetType) {
        return FastjsonConverter.INSTANCE.convert(value, targetType);
    }
}

