/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.bean.Converter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.TypeUtils;

public class FastjsonConverter
implements Converter {
    public static Converter INSTANCE = new FastjsonConverter();

    @Override
    public <T> T convert(Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (targetType == valueClass || targetType == Object.class || targetType.isAssignableFrom(valueClass)) {
            return (T)value;
        }
        if (targetType == String.class) {
            return (T)JSON.toJSONString((Object)value);
        }
        if (value instanceof String) {
            return (T)JSON.parseObject((String)((String)value), targetType);
        }
        return (T)TypeUtils.castToJavaBean((Object)JSON.toJSON((Object)value), targetType);
    }
}

