/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.attr.AbstractAttrable;
import cn.gtmap.egovplat.core.bean.Attrable;
import cn.gtmap.egovplat.core.util.ArrayUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class CompositeAttrableEx
extends AbstractAttrable
implements Serializable {
    private static final long serialVersionUID = 6817948390932263126L;
    private final Attrable attr;
    private final List<Attrable> parents;

    public CompositeAttrableEx(Attrable attr, Attrable ... parents) {
        this.attr = attr;
        this.parents = ArrayUtils.asList(parents);
    }

    public CompositeAttrableEx(Attrable attr, Collection<Attrable> parents) {
        this.attr = attr;
        this.parents = Lists.newArrayList(parents);
    }

    public Attrable getAttr() {
        return this.attr;
    }

    @Override
    public boolean isAttrsEmpty() {
        if (!this.attr.isAttrsEmpty()) {
            return false;
        }
        for (Attrable p : this.parents) {
            if (p.isAttrsEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAttr(String key) {
        if (this.attr.hasAttr(key)) {
            return true;
        }
        for (Attrable p : this.parents) {
            if (!p.hasAttr(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAttr(String key) {
        if (this.attr.hasAttr(key)) {
            return this.attr.getAttr(key);
        }
        for (Attrable p : this.parents) {
            if (!p.hasAttr(key)) continue;
            return p.getAttr(key);
        }
        return null;
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        if (this.attr.hasAttr(key)) {
            return this.attr.getAttr(key, targetType);
        }
        for (Attrable p : this.parents) {
            if (!p.hasAttr(key)) continue;
            return p.getAttr(key, targetType);
        }
        return null;
    }

    @Override
    public Collection<String> getAttrKeys() {
        LinkedHashSet keys = Sets.newLinkedHashSet(this.attr.getAttrKeys());
        for (Attrable p : this.parents) {
            keys.addAll(p.getAttrKeys());
        }
        return keys;
    }

    @Override
    public void setAttr(String key, Object value) {
        this.attr.setAttr(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        this.attr.setAttrs(map);
    }

    @Override
    public void removeAttr(String key) {
        this.attr.removeAttr(key);
    }

    @Override
    public String toString() {
        return this.attr.toString();
    }
}

