/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.egovplat.core.attr;

import cn.gtmap.egovplat.core.attr.AbstractAttrable;
import cn.gtmap.egovplat.core.bean.Attrable;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public class CompositeAttrable
extends AbstractAttrable
implements Serializable {
    private static final long serialVersionUID = 7077593803642902540L;
    private final Attrable attr;
    private final Attrable parent;

    public CompositeAttrable(Attrable attr, Attrable parent) {
        this.attr = attr;
        this.parent = parent;
    }

    public Attrable getAttr() {
        return this.attr;
    }

    @Override
    public boolean isAttrsEmpty() {
        return this.attr.isAttrsEmpty() && this.parent.isAttrsEmpty();
    }

    @Override
    public boolean hasAttr(String key) {
        return this.attr.hasAttr(key) || this.parent.hasAttr(key);
    }

    @Override
    public String getAttr(String key) {
        return this.attr.hasAttr(key) ? this.attr.getAttr(key) : this.parent.getAttr(key);
    }

    @Override
    public <T> T getAttr(String key, Class<T> targetType) {
        return this.attr.hasAttr(key) ? this.attr.getAttr(key, targetType) : this.parent.getAttr(key, targetType);
    }

    @Override
    public Collection<String> getAttrKeys() {
        LinkedHashSet keys = Sets.newLinkedHashSet(this.attr.getAttrKeys());
        keys.addAll(this.parent.getAttrKeys());
        return keys;
    }

    @Override
    public void setAttr(String key, Object value) {
        this.attr.setAttr(key, value);
    }

    @Override
    public void setAttrs(Map<String, ?> map) {
        this.attr.setAttrs(map);
    }

    @Override
    public void removeAttr(String key) {
        this.attr.removeAttr(key);
    }

    @Override
    public String toString() {
        return this.attr.toString();
    }
}

